/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.Ulimit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.Ansi;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Eventually;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.test.ThreadLeakChecker;
import org.infinispan.commons.util.OS;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.Containers;
import org.infinispan.server.test.core.CountdownLatchLoggingConsumer;
import org.infinispan.server.test.core.InfinispanGenericContainer;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.JBossLoggingConsumer;
import org.infinispan.server.test.core.NettyLeakDetectionLoggingConsumer;
import org.jboss.logging.BasicLogger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.images.builder.dockerfile.statement.RawStatement;
import org.testcontainers.images.builder.dockerfile.statement.Statement;

public class ContainerInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    private static final Log log = LogFactory.getLog(ContainerInfinispanServerDriver.class);
    private static final String STARTUP_MESSAGE_REGEX = ".*ISPN080001.*";
    private static final String SHUTDOWN_MESSAGE_REGEX = ".*ISPN080003.*";
    private static final String CLUSTER_VIEW_REGEX = ".*ISPN000093.*(?<=\\()(%1$d)(?=\\)).*|.*ISPN000094.*(?<=\\()(%1$d)(?=\\)).*";
    private static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.container.timeoutSeconds", 45);
    private static final Long IMAGE_MEMORY = Long.getLong("org.infinispan.test.server.container.memory", null);
    private static final Long IMAGE_MEMORY_SWAP = Long.getLong("org.infinispan.test.server.container.memorySwap", null);
    public static final String INFINISPAN_SERVER_HOME = "/opt/infinispan";
    public static final String JACOCO_COVERAGE_CONTAINER_PATH = "/opt/infinispan/bin/jacoco.exec";
    public static final String JACOCO_COVERAGE_HOST_PATH = "target/";
    public static final String JDK_BASE_IMAGE_NAME = "registry.access.redhat.com/ubi9/openjdk-21-runtime";
    private static final String[] IMAGE_DEPENDENCIES = new String[]{"file", "gzip", "iproute", "lsof", "tar", "vim-minimal"};
    public static final String IMAGE_USER = "185";
    public static final Integer[] EXPOSED_PORTS = new Integer[]{11222, 11221, 11223, 11224, 11225, 7800, 46655, 9999};
    public static final String SNAPSHOT_IMAGE = "localhost/infinispan/server-snapshot";
    private final List<InfinispanGenericContainer> containers;
    private final String[] volumes;
    private String name;
    ImageFromDockerfile image;
    private static final List<String> sites = new ArrayList<String>();
    private final NettyLeakDetectionLoggingConsumer leakDetectionLoggingConsumer = new NettyLeakDetectionLoggingConsumer();

    protected ContainerInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, Containers.getDockerBridgeAddress());
        int totalAmount = configuration.expectedServers() > 0 ? configuration.expectedServers() : configuration.numServers();
        this.containers = new ArrayList<InfinispanGenericContainer>(totalAmount);
        for (int i = 0; i < totalAmount; ++i) {
            this.containers.add(null);
        }
        this.volumes = new String[totalAmount];
    }

    public static void cleanup() {
        ContainerInfinispanServerDriver.cleanup(SNAPSHOT_IMAGE);
    }

    public static void cleanup(String imageName) {
        try {
            log.infof("Removing temporary image %s", (Object)imageName);
            Containers.DOCKER_CLIENT.removeImageCmd(imageName).exec();
            log.infof("Removed temporary image %s", (Object)imageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void start(String fqcn, File rootDir) {
        this.configureImage(fqcn, rootDir);
        int numServers = this.configuration.numServers();
        CountdownLatchLoggingConsumer clusterLatch = new CountdownLatchLoggingConsumer(numServers, String.format(CLUSTER_VIEW_REGEX, this.configuration.expectedServers() > 0 ? this.configuration.expectedServers() : numServers));
        if (this.configuration.isParallelStartup()) {
            CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(numServers, STARTUP_MESSAGE_REGEX);
            IntStream.range(0, this.configuration.numServers()).forEach(i -> this.createContainer(i, new Consumer[]{startupLatch, clusterLatch}));
            Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
        } else {
            for (int i2 = 0; i2 < this.configuration.numServers(); ++i2) {
                CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
                this.createContainer(i2, new Consumer[]{startupLatch, clusterLatch});
                Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
            }
        }
        Exceptions.unchecked(() -> clusterLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
    }

    public void configureImage(String fqcn) {
        this.status = ComponentStatus.INITIALIZING;
        try {
            this.configureImage(fqcn, this.rootDir);
        }
        catch (Throwable t) {
            log.errorf(t, "Unable to configure server image for %s", (Object)this.name);
            this.status = ComponentStatus.FAILED;
            throw t;
        }
    }

    private void configureImage(String fqcn, File rootDir) {
        Object imageName;
        File libDir;
        Path tmp;
        boolean preserveImageAfterTest;
        ArrayList<String> args;
        block20: {
            this.name = ContainerInfinispanServerDriver.abbreviate(fqcn);
            String jGroupsStack = !this.configuration.properties().containsKey("infinispan.cluster.stack") ? System.getProperty("infinispan.cluster.stack") : null;
            ContainerInfinispanServerDriver.createServerHierarchy(rootDir);
            args = new ArrayList<String>();
            args.add("bin/server.sh");
            args.add("-c");
            args.add(new File(this.configuration.configurationFile()).getName());
            args.add("-b");
            args.add("SITE_LOCAL");
            args.add("-Djgroups.bind.address=SITE_LOCAL");
            if (jGroupsStack != null) {
                args.add("-j");
                args.add(jGroupsStack);
            }
            args.add("-Dinfinispan.cluster.name=" + (this.configuration.getClusterName() != null ? this.configuration.getClusterName() : this.name));
            args.add("-Dorg.infinispan.test.host.address=" + this.testHostAddress.getHostAddress());
            if (this.configuration.isJMXEnabled()) {
                args.add("--jmx");
                args.add(Integer.toString(9999));
            }
            args.add("-Dio.netty.leakDetection.level=paranoid");
            String logFile = System.getProperty("org.infinispan.test.server.container.logFile");
            if (logFile != null) {
                Path logPath = Paths.get(logFile, new String[0]);
                String logFileName = logPath.getFileName().toString();
                if (logPath.isAbsolute()) {
                    try {
                        Files.copy(logPath, new File(this.getConfDir(), logFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy the log file", e);
                    }
                }
                args.add("-l");
                args.add(logFileName);
            }
            Properties properties = new Properties();
            properties.setProperty("infinispan.server.config.path", Paths.get(INFINISPAN_SERVER_HOME, "conf").toString());
            properties.setProperty("infinispan.cluster.name", this.name);
            properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
            this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> args.add("-D" + String.valueOf(k) + "=" + StringPropertyReplacer.replaceProperties((String)((String)v), (Properties)properties))));
            this.configureSite(args);
            preserveImageAfterTest = Boolean.parseBoolean(this.configuration.properties().getProperty("org.infinispan.test.server.container.preserveImage", "false"));
            tmp = Paths.get(CommonsTestingUtil.tmpDirectory(this.getClass()), new String[0]);
            libDir = new File(rootDir, "lib");
            libDir.mkdirs();
            this.copyArtifactsToDataDir();
            this.copyArtifactsToUserLibDir(libDir);
            if (ContainerInfinispanServerDriver.isCoverage()) {
                this.addArtifactsToLibDir(libDir, "org.jacoco:org.jacoco.agent:" + System.getProperty("version.jacoco") + ":runtime");
            }
            try {
                URL resource = ContainerInfinispanServerDriver.class.getResource("/overlay");
                if (resource == null) break block20;
                URI overlayUri = resource.toURI();
                if ("jar".equals(overlayUri.getScheme())) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(overlayUri, Collections.emptyMap());){
                        Files.walkFileTree(fileSystem.getPath("/overlay", new String[0]), (FileVisitor<? super Path>)new CommonsTestingUtil.CopyFileVisitor(tmp, true, f -> f.setExecutable(true, false)));
                        break block20;
                    }
                }
                Files.walkFileTree(Paths.get(overlayUri), (FileVisitor<? super Path>)new CommonsTestingUtil.CopyFileVisitor(tmp, true, f -> f.setExecutable(true, false)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        log.infof("Creating image %s", (Object)this.name);
        String versionToUse = this.configuration.properties().getProperty("org.infinispan.test.server.version", Version.getMajorMinor());
        String baseImageName = this.configuration.properties().getProperty("org.infinispan.test.server.container.baseImageName");
        if (baseImageName == null) {
            String serverOutputDir = this.configuration.properties().getProperty("org.infinispan.test.server.dir");
            if (serverOutputDir == null) {
                imageName = "quay.io/infinispan/server:" + versionToUse;
                log.infof("Using prebuilt image '%s'", imageName);
            } else {
                imageName = this.createServerImage(serverOutputDir, versionToUse);
            }
        } else {
            imageName = baseImageName;
            log.infof("Using prebuilt image '%s'", imageName);
        }
        this.image = (ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile("localhost/infinispan/server-" + this.name.toLowerCase(), !preserveImageAfterTest).withFileFromPath("test", rootDir.toPath())).withFileFromPath("tmp", tmp)).withFileFromPath("lib", libDir.toPath())).withDockerfileFromBuilder(arg_0 -> this.lambda$configureImage$3((String)imageName, versionToUse, args, arg_0));
        this.image.get();
        log.infof("Created image %s", (Object)this.name);
    }

    public void startAdditionalServer(int expectedClusterSize, String volumeName) {
        try {
            CountdownLatchLoggingConsumer clusterLatch = new CountdownLatchLoggingConsumer(1, String.format(CLUSTER_VIEW_REGEX, expectedClusterSize));
            CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
            log.infof("Starting new single server for container %s with volume %s", (Object)this.name, (Object)volumeName);
            this.createContainer(this.createdContainers(), volumeName, new Consumer[]{startupLatch, clusterLatch});
            Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
            Exceptions.unchecked(() -> clusterLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
            this.status = ComponentStatus.RUNNING;
        }
        catch (Throwable t) {
            log.errorf(t, "Unable to start individual server for %s", (Object)this.name);
            this.status = ComponentStatus.FAILED;
            throw t;
        }
    }

    private int createdContainers() {
        return (int)this.containers.stream().filter(Objects::nonNull).count();
    }

    private void configureSite(List<String> args) {
        if (this.configuration.site() == null) {
            return;
        }
        args.add("-Drelay.site_name=" + this.configuration.site());
        args.add("-Djgroups.cluster.mcast_port=" + this.configuration.siteDiscoveryPort());
    }

    private static Path cleanServerDirectory(Path serverOutputPath) {
        Util.recursiveFileRemove((String)serverOutputPath.resolve("server").resolve("data").toString());
        Util.recursiveFileRemove((String)serverOutputPath.resolve("server").resolve("log").toString());
        return serverOutputPath;
    }

    private static boolean isCoverage() {
        String jacocoVersion = System.getProperty("version.jacoco");
        return jacocoVersion != null;
    }

    private GenericContainer<?> createContainer(int i, Consumer<OutputFrame> ... logConsumers) {
        return this.createContainer(i, (String)null, logConsumers);
    }

    private GenericContainer<?> createContainer(int i, String volumeName, Consumer<OutputFrame> ... logConsumers) {
        String reset;
        String color;
        if (volumeName != null) {
            if (this.volumes[i] != null && !this.volumes[i].equals(volumeName)) {
                throw new IllegalArgumentException("Provided volume name " + volumeName + " doesn't match already present volume of " + this.volumes[i]);
            }
            this.volumes[i] = volumeName;
        } else if (Boolean.parseBoolean(this.configuration.properties().getProperty("org.infinispan.test.server.container.volume"))) {
            if (this.volumes[i] == null) {
                volumeName = Util.threadLocalRandomUUID().toString();
                Containers.DOCKER_CLIENT.createVolumeCmd().withName(volumeName).exec();
                this.volumes[i] = volumeName;
            } else {
                volumeName = this.volumes[i];
            }
        }
        String volumeToUse = volumeName;
        GenericContainer container = new GenericContainer((Future)this.image).withCreateContainerCmdModifier(cmd -> {
            String ulimit;
            if (volumeToUse != null) {
                cmd.getHostConfig().withMounts(Collections.singletonList(new Mount().withSource(volumeToUse).withTarget(this.serverPath() + "/data").withType(MountType.VOLUME)));
            }
            if (IMAGE_MEMORY != null) {
                cmd.getHostConfig().withMemory(IMAGE_MEMORY);
            }
            if (IMAGE_MEMORY_SWAP != null) {
                cmd.getHostConfig().withMemorySwap(IMAGE_MEMORY_SWAP);
            }
            if ((ulimit = this.configuration.properties().getProperty("org.infinispan.test.server.container.ulimit")) != null) {
                String[] softHard = ulimit.split(",");
                assert (softHard.length == 2) : "Ulimit property must have format '<soft>,<hard>'";
                long soft = Long.parseLong(softHard[0]);
                long hard = Long.parseLong(softHard[1]);
                cmd.getHostConfig().withUlimits(new Ulimit[]{new Ulimit("nofile", soft, hard)});
            }
        });
        if (this.configuration.numServers() == 1 && (OS.getCurrentOs().equals((Object)OS.MAC_OS) || OS.getCurrentOs().equals((Object)OS.WINDOWS))) {
            container.addExposedPorts(new int[]{11222, 7800});
        }
        String debug = this.configuration.properties().getProperty("org.infinispan.test.server.container.debug");
        StringBuilder javaOpts = new StringBuilder();
        String site = this.configuration.site();
        if (site != null && !sites.contains(site)) {
            sites.add(site);
        }
        if (i == 0 && site == null && !Boolean.parseBoolean(this.configuration.properties().getProperty("org.infinispan.test.server.requireJoinTimeout"))) {
            javaOpts.append("-D").append("jgroups.join_timeout").append("=0");
        }
        if (debug != null && Integer.parseInt(debug) == i) {
            javaOpts.append(" ").append(this.debugJvmOption());
            log.infof("Container debug enabled with options '%s'%n", (Object)javaOpts);
        }
        if (ContainerInfinispanServerDriver.isCoverage()) {
            String jacocoVersion = System.getProperty("version.jacoco");
            javaOpts.append(" -javaagent:").append(INFINISPAN_SERVER_HOME).append("/server/lib/org.jacoco.agent-").append(jacocoVersion).append("-runtime.jar=output=file,destfile=").append(JACOCO_COVERAGE_CONTAINER_PATH).append(",append=true");
            container.withEnv("JAVA_GC_MAX_METASPACE_SIZE", "512M");
        }
        if (!javaOpts.isEmpty()) {
            container.withEnv("JAVA_OPTS", javaOpts.toString());
            container.withEnv("JAVA_OPTIONS", javaOpts.toString());
        }
        if (Ansi.useColor) {
            int offset = site == null ? 0 : 4 * sites.indexOf(site);
            color = Ansi.DISTINCT_COLORS[(offset + i) % Ansi.DISTINCT_COLORS.length];
            reset = "\u001b[0m";
        } else {
            color = "";
            reset = "";
        }
        String logPrefix = site == null ? this.name + "#" + i : this.name + "#" + site + "#" + i;
        container.withLogConsumer((Consumer)((Object)new JBossLoggingConsumer((BasicLogger)org.infinispan.util.logging.LogFactory.getLogger((String)"CONTAINER")).withPrefix(color + "[" + logPrefix + "]").withSuffix(reset))).withLogConsumer((Consumer)((Object)this.leakDetectionLoggingConsumer));
        for (Consumer<OutputFrame> consumer : logConsumers) {
            container.withLogConsumer(consumer);
        }
        String containerAndSite = i + (String)(site != null ? "-" + site : "");
        log.infof("Starting container %s", (Object)containerAndSite);
        container.start();
        this.containers.set(i, new InfinispanGenericContainer(container));
        log.infof("Started container %s", (Object)containerAndSite);
        return container;
    }

    @Override
    public void stop() {
        String site = this.configuration.site();
        for (int i = 0; i < this.containers.size(); ++i) {
            this.stop(i);
        }
        if (this.image != null) {
            ContainerInfinispanServerDriver.cleanup(this.image.getDockerImageName());
        }
        ThreadLeakChecker.ignoreThreadsContaining((String)"docker-java-stream-");
        if (this.leakDetectionLoggingConsumer.leakDetected()) {
            throw new IllegalStateException("Leak detected");
        }
    }

    @Override
    public boolean isRunning(int server) {
        return this.containers.get(server).isRunning();
    }

    @Override
    public int serverCount() {
        return this.createdContainers();
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), port);
    }

    @Override
    public InetAddress getServerAddress(int server) {
        InfinispanGenericContainer container = this.containers.get(server);
        return container.getIpAddress();
    }

    @Override
    public void pause(int server) {
        InfinispanGenericContainer container = this.containers.get(server);
        container.pause();
        Eventually.eventually((String)"Container wasn't paused.", container::isPaused);
        System.out.printf("[%d] PAUSE %n", server);
    }

    @Override
    public void resume(int server) {
        InfinispanGenericContainer container = this.containers.get(server);
        container.resume();
        Eventually.eventually((String)"Container didn't resume.", () -> this.isRunning(server));
        System.out.printf("[%d] RESUME %n", server);
    }

    @Override
    public void stop(int server) {
        InfinispanGenericContainer container = this.containers.get(server);
        String site = this.configuration.site();
        String containerAndSite = server + (String)(site != null ? "-" + site : "");
        if (container != null) {
            log.infof("Stopping container %s", (Object)containerAndSite);
            CountdownLatchLoggingConsumer latch = new CountdownLatchLoggingConsumer(1, SHUTDOWN_MESSAGE_REGEX);
            container.withLogConsumer(latch);
            container.stop();
            if (ContainerInfinispanServerDriver.isCoverage() && !container.isKilled()) {
                container.uploadCoverageInfoToHost(JACOCO_COVERAGE_CONTAINER_PATH, JACOCO_COVERAGE_HOST_PATH + this.name + "-" + server + ".exec");
            }
            Eventually.eventually((String)"Container wasn't stopped.", () -> !this.isRunning(server));
            log.infof("Stopped container %s", (Object)containerAndSite);
            System.out.printf("[%d] STOP %n", server);
        } else {
            log.infof("Container %s not present", (Object)containerAndSite);
        }
    }

    public String volumeId(int server) {
        return this.volumes[server];
    }

    @Override
    public void kill(int server) {
        InfinispanGenericContainer container = this.containers.get(server);
        if (container != null) {
            container.kill();
            Eventually.eventually((String)"Container wasn't killed.", () -> !this.isRunning(server));
            System.out.printf("[%d] KILL %n", server);
            container.setKilled(true);
        }
    }

    @Override
    public void restart(int server) {
        CountdownLatchLoggingConsumer startupLatch = new CountdownLatchLoggingConsumer(1, STARTUP_MESSAGE_REGEX);
        this.restart(server, (Consumer<OutputFrame>)((Object)startupLatch));
        Exceptions.unchecked(() -> startupLatch.await(TIMEOUT_SECONDS, TimeUnit.SECONDS));
    }

    public void restart(int server, Consumer<OutputFrame> consumer) {
        if (this.isRunning(server)) {
            throw new IllegalStateException("Server " + server + " is still running");
        }
        this.stop(server);
        log.infof("Restarting container %d", (Object)server);
        this.createContainer(server, consumer);
    }

    @Override
    public void restartCluster() {
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            this.restart(i);
        }
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server, String username, String password, Consumer<Closeable> reaper) {
        return (MBeanServerConnection)Exceptions.unchecked(() -> {
            InfinispanGenericContainer container = this.containers.get(server);
            String urlPath = "/jndi/rmi://" + String.valueOf(container.getIpAddress()) + ":9999/jmxrmi";
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            Registry registry = LocateRegistry.getRegistry(container.getIpAddress().getHostAddress(), 9999);
            RMIServer stub = (RMIServer)registry.lookup("jmxrmi");
            RMIConnector connector = new RMIConnector(stub, null);
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            env.put("jmx.remote.credentials", new String[]{username, password});
            connector.connect(env);
            log.infof("Connecting to JMX URL %s", (Object)url.toString());
            reaper.accept(connector);
            return connector.getMBeanServerConnection();
        });
    }

    @Override
    public int getTimeout() {
        return TIMEOUT_SECONDS;
    }

    private String serverPath() {
        return String.format("%s/server", INFINISPAN_SERVER_HOME);
    }

    private String serverPathFrom(String path) {
        return String.format("%s/%s", this.serverPath(), path);
    }

    @Override
    public String syncFilesFromServer(int server, String path) {
        String string;
        block12: {
            Object serverPath = Paths.get(path, new String[0]).isAbsolute() ? path : "/opt/infinispan/server/" + path;
            InputStream is = Containers.DOCKER_CLIENT.copyArchiveFromContainerCmd(this.containers.get(server).getContainerId(), (String)serverPath).exec();
            try {
                TarArchiveInputStream tar = new TarArchiveInputStream(is);
                Path basePath = this.getRootDir().toPath().resolve(Integer.toString(server));
                Util.recursiveFileRemove((Path)basePath.resolve(path));
                TarArchiveEntry entry = tar.getNextTarEntry();
                while (entry != null) {
                    Path entryPath = basePath.resolve(entry.getName());
                    if (entry.isDirectory()) {
                        Files.createDirectories(entryPath, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                        OutputStream os = Files.newOutputStream(entryPath, new OpenOption[0]);
                        int b = tar.read();
                        while (b >= 0) {
                            os.write(b);
                            b = tar.read();
                        }
                        Util.close((AutoCloseable)os);
                    }
                    entry = tar.getNextTarEntry();
                }
                string = basePath.toString();
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String syncFilesToServer(int server, String path) {
        Path local = Paths.get(path, new String[0]);
        final Path parent = local.getParent();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (final TarArchiveOutputStream tar = new TarArchiveOutputStream((OutputStream)bos);){
                Files.walkFileTree(local, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                    final /* synthetic */ ContainerInfinispanServerDriver this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Path relativize = parent.relativize(dir);
                        TarArchiveEntry entry = new TarArchiveEntry(dir.toFile(), relativize.toString());
                        entry.setMode(16895);
                        tar.putArchiveEntry((ArchiveEntry)entry);
                        tar.closeArchiveEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativize = parent.relativize(file);
                        TarArchiveEntry entry = new TarArchiveEntry(file.toFile(), relativize.toString());
                        entry.setMode(33206);
                        tar.putArchiveEntry((ArchiveEntry)entry);
                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                            int b = is.read();
                            while (b >= 0) {
                                tar.write(b);
                                b = is.read();
                            }
                        }
                        tar.closeArchiveEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
                tar.close();
                Containers.DOCKER_CLIENT.copyArchiveToContainerCmd(this.containers.get(server).getContainerId()).withTarInputStream((InputStream)new ByteArrayInputStream(bos.toByteArray())).withRemotePath("/tmp").exec();
                string = Paths.get("/tmp", new String[0]).resolve(local.getFileName()).toString();
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String createServerImage(String serverOutputDir, String versionToUse) {
        String snapshotImageName = this.configuration.properties().getProperty("org.infinispan.test.server.container.snapshotImageName", SNAPSHOT_IMAGE);
        try {
            InspectImageResponse response = Containers.DOCKER_CLIENT.inspectImageCmd(snapshotImageName).exec();
            log.infof("Reusing existing image: %s", (Object)response);
            String name = response.getConfig().getImage();
            if (name == null || name.isEmpty()) {
                return snapshotImageName;
            }
            return name;
        }
        catch (NotFoundException e) {
            Path serverOutputPath = Paths.get(serverOutputDir, new String[0]).normalize();
            if (Files.notExists(serverOutputPath, new LinkOption[0])) {
                throw new RuntimeException("Cannot create server image: no server at " + String.valueOf(serverOutputPath));
            }
            ImageFromDockerfile image = (ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile(snapshotImageName, false).withFileFromPath("build", ContainerInfinispanServerDriver.cleanServerDirectory(serverOutputPath))).withDockerfileFromBuilder(builder -> ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(JDK_BASE_IMAGE_NAME)).env("INFINISPAN_SERVER_HOME", INFINISPAN_SERVER_HOME)).env("INFINISPAN_VERSION", versionToUse)).label("name", "Infinispan Server")).label("version", versionToUse)).label("release", versionToUse)).label("architecture", Containers.imageArchitecture())).withStatement((Statement)new RawStatement("COPY", "--chown=185:185 build /opt/infinispan"))).user("root")).run(String.format("microdnf install -y %s", String.join((CharSequence)" ", IMAGE_DEPENDENCIES)))).user(IMAGE_USER));
            log.infof("Building server snapshot image %s from %s", (Object)snapshotImageName, (Object)serverOutputPath);
            image.get();
            return image.getDockerImageName();
        }
    }

    private /* synthetic */ void lambda$configureImage$3(String imageName, String versionToUse, List args, DockerfileBuilder builder) {
        ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(imageName)).env("INFINISPAN_SERVER_HOME", INFINISPAN_SERVER_HOME)).env("INFINISPAN_VERSION", versionToUse)).label("name", "Infinispan Server")).label("version", versionToUse)).label("release", versionToUse)).label("architecture", Containers.imageArchitecture());
        ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.user(IMAGE_USER)).withStatement((Statement)new RawStatement("COPY", "--chown=185:185 test /opt/infinispan/server"))).withStatement((Statement)new RawStatement("COPY", "--chown=185:185 tmp /opt/infinispan"))).withStatement((Statement)new RawStatement("COPY", "--chown=185:185 lib " + this.serverPathFrom("lib")))).workDir(INFINISPAN_SERVER_HOME)).entryPoint(args.toArray(new String[0]))).expose(EXPOSED_PORTS);
    }

    static {
        ContainerInfinispanServerDriver.cleanup();
    }
}

