/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.rollingupgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class RollingUpgradeConfigurationBuilder {
    private final String fromVersion;
    private final String toVersion;
    private final String name;
    private int nodeCount = 3;
    private String serverConfigurationFile = "infinispan.xml";
    private boolean defaultServerConfigurationFile = true;
    private final Properties properties = new Properties();
    private final List<Archive<?>> customArchives = new ArrayList();
    private final List<String> mavenArtifacts = new ArrayList<String>();
    private final List<InfinispanServerListener> listeners = new ArrayList<InfinispanServerListener>();
    private String jgroupsProtocol = System.getProperty("infinispan.cluster.stack", "tcp");
    private int serverCheckTimeSecs = 30;
    private boolean useSharedDataMount = true;
    private BiConsumer<Throwable, RollingUpgradeHandler> exceptionHandler = (t, uh) -> {
        throw new RuntimeException((Throwable)t);
    };
    private Function<ConfigurationBuilder, ConfigurationBuilder> configurationHandler = Function.identity();
    private Consumer<RollingUpgradeHandler> initialHandler = uh -> {
        RemoteCacheManager rcm = uh.getRemoteCacheManager();
        RemoteCache cache = rcm.administration().createCache("rolling-upgrade", (BasicConfiguration)new StringConfiguration("<replicated-cache></replicated-cache>"));
        cache.put((Object)"foo", (Object)"bar");
    };
    private Predicate<RollingUpgradeHandler> isValidServerState = RollingUpgradeConfigurationBuilder.hotrodPredicate("rolling-upgrade", (uh, rc) -> {
        String value = (String)rc.get((Object)"foo");
        return "bar".equals(value);
    });

    public static Predicate<RollingUpgradeHandler> hotrodPredicate(String cacheName, BiPredicate<RollingUpgradeHandler, RemoteCache<String, String>> function) {
        return uh -> {
            RemoteCacheManager rcm = uh.getRemoteCacheManager();
            RemoteCache cache = rcm.getCache(cacheName);
            if (!function.test((RollingUpgradeHandler)uh, (RemoteCache<String, String>)cache)) {
                return false;
            }
            Set servers = cache.getCacheTopologyInfo().getSegmentsPerServer().keySet();
            return servers.size() == uh.getConfiguration().nodeCount() + (uh.getCurrentState() == RollingUpgradeHandler.STATE.REMOVED_OLD ? -1 : 0);
        };
    }

    public RollingUpgradeConfigurationBuilder(String name, String fromVersion, String toVersion) {
        this.fromVersion = Objects.requireNonNull(fromVersion);
        this.toVersion = Objects.requireNonNull(toVersion);
        this.name = name;
    }

    public RollingUpgradeConfigurationBuilder nodeCount(int nodeCount) {
        if (nodeCount <= 0) {
            throw new IllegalArgumentException("nodeCount must be greater than 0");
        }
        this.nodeCount = nodeCount;
        return this;
    }

    public RollingUpgradeConfigurationBuilder jgroupsProtocol(String jgroupsProtocol) {
        this.jgroupsProtocol = Objects.requireNonNull(jgroupsProtocol);
        return this;
    }

    public RollingUpgradeConfigurationBuilder serverCheckTimeSecs(int serverCheckTimeSecs) {
        if (this.nodeCount <= 0) {
            throw new IllegalArgumentException("serverCheckTimeSecs must be greater than 0");
        }
        this.serverCheckTimeSecs = serverCheckTimeSecs;
        return this;
    }

    public RollingUpgradeConfigurationBuilder exceptionHandler(BiConsumer<Throwable, RollingUpgradeHandler> exceptionHandler) {
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler);
        return this;
    }

    public RollingUpgradeConfigurationBuilder sharedDataMount(boolean useSharedDataMount) {
        this.useSharedDataMount = useSharedDataMount;
        return this;
    }

    public RollingUpgradeConfigurationBuilder useDefaultServerConfiguration(String serverConfigurationFile) {
        this.serverConfigurationFile = Objects.requireNonNull(serverConfigurationFile);
        this.defaultServerConfigurationFile = true;
        return this;
    }

    public RollingUpgradeConfigurationBuilder useCustomServerConfiguration(String serverConfigurationFile) {
        this.serverConfigurationFile = Objects.requireNonNull(serverConfigurationFile);
        this.defaultServerConfigurationFile = false;
        return this;
    }

    public RollingUpgradeConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
        return this;
    }

    public RollingUpgradeConfigurationBuilder addArchives(Archive<?> ... javaArchives) {
        this.customArchives.addAll(List.of(javaArchives));
        return this;
    }

    public RollingUpgradeConfigurationBuilder addMavenArtifacts(String ... mavenArtifacts) {
        for (String artifact : mavenArtifacts) {
            this.mavenArtifacts.add(Objects.requireNonNull(artifact));
        }
        return this;
    }

    public RollingUpgradeConfigurationBuilder addListener(InfinispanServerListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public RollingUpgradeConfigurationBuilder handlers(Consumer<RollingUpgradeHandler> initialHandler, Predicate<RollingUpgradeHandler> isValidServerState) {
        this.initialHandler = Objects.requireNonNull(initialHandler);
        this.isValidServerState = Objects.requireNonNull(isValidServerState);
        return this;
    }

    public RollingUpgradeConfigurationBuilder configurationUpdater(Function<ConfigurationBuilder, ConfigurationBuilder> updateConfig) {
        this.configurationHandler = Objects.requireNonNull(updateConfig);
        return this;
    }

    public RollingUpgradeConfiguration build() {
        return new RollingUpgradeConfiguration(this.nodeCount, this.fromVersion, this.toVersion, this.name, this.jgroupsProtocol, this.serverCheckTimeSecs, this.useSharedDataMount, this.serverConfigurationFile, this.defaultServerConfigurationFile, this.properties, (Archive[])this.customArchives.toArray(new JavaArchive[0]), this.mavenArtifacts.toArray(new String[0]), this.listeners, this.exceptionHandler, this.initialHandler, this.isValidServerState, this.configurationHandler);
    }
}

