/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.rollingupgrade;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.util.OS;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerConfigBuilder;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class RollingUpgradeHandler {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final RollingUpgradeConfiguration configuration;
    private final int nodeCount;
    private final String clusterName;
    private int nodeLeft;
    private final String versionFrom;
    private final String versionTo;
    private String toImageCreated;
    private String fromImageCreated;
    private ConfigAndDriver fromDriver;
    private ConfigAndDriver toDriver;
    private RemoteCacheManager remoteCacheManager;
    private RedisClusterClient respClient;
    private MemcachedClient[] memcachedClients;
    private RestClient[] restClients;
    private STATE currentState = STATE.NOT_STARTED;

    private RollingUpgradeHandler(RollingUpgradeConfiguration configuration) {
        this.nodeLeft = this.nodeCount = configuration.nodeCount();
        this.versionFrom = configuration.fromVersion();
        this.versionTo = configuration.toVersion();
        this.configuration = configuration;
        this.restClients = new RestClient[this.nodeCount];
        this.memcachedClients = new MemcachedClient[this.nodeCount];
        this.clusterName = configuration.name();
    }

    public String getToImageCreated() {
        return this.toImageCreated;
    }

    public String getFromImageCreated() {
        return this.fromImageCreated;
    }

    public ContainerInfinispanServerDriver getFromDriver() {
        return this.fromDriver.containerInfinispanServerDriver;
    }

    public ContainerInfinispanServerDriver getToDriver() {
        return this.toDriver.containerInfinispanServerDriver;
    }

    public InfinispanServerTestConfiguration getFromConfig() {
        return this.fromDriver.infinispanServerTestConfiguration;
    }

    public InfinispanServerTestConfiguration getToConfig() {
        return this.toDriver.infinispanServerTestConfiguration;
    }

    public RollingUpgradeConfiguration getConfiguration() {
        return this.configuration;
    }

    public RemoteCacheManager getRemoteCacheManager() {
        if (this.remoteCacheManager == null) {
            this.remoteCacheManager = this.createRemoteCacheManager();
        }
        return this.remoteCacheManager;
    }

    public RestClient rest(int server, RestClientConfigurationBuilder builder) {
        if (this.restClients[server] != null) {
            return this.restClients[server];
        }
        InetAddress address = this.getCurrentState() == STATE.OLD_RUNNING ? this.fromDriver.containerInfinispanServerDriver.getServerAddress(server) : this.toDriver.containerInfinispanServerDriver.getServerAddress(server);
        builder.addServer().host(address.getHostAddress()).port(11222);
        this.restClients[server] = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        return this.restClients[server];
    }

    public RedisClusterClient resp(RedisURI.Builder builder) {
        if (this.respClient != null) {
            return this.respClient;
        }
        int nodeCount = this.configuration.nodeCount();
        Function<Integer, InetAddress> addressFunction = i -> this.fromDriver.containerInfinispanServerDriver.isRunning((int)i) ? this.fromDriver.containerInfinispanServerDriver.getServerAddress((int)i) : this.toDriver.containerInfinispanServerDriver.getServerAddress((int)i);
        ArrayList<RedisURI> uris = new ArrayList<RedisURI>();
        for (int i2 = 0; i2 < nodeCount; ++i2) {
            InetAddress address = addressFunction.apply(i2);
            RedisURI uri = builder.withHost(address.getHostAddress()).withPort(11222).withTimeout(Duration.ofSeconds(30L)).build();
            uris.add(uri);
        }
        this.respClient = RedisClusterClient.create(uris);
        return this.respClient;
    }

    public MemcachedClient memcached(int server, ConnectionFactoryBuilder builder) {
        if (this.memcachedClients[server] != null) {
            return this.memcachedClients[server];
        }
        InetAddress address = this.getCurrentState() == STATE.OLD_RUNNING ? this.fromDriver.containerInfinispanServerDriver.getServerAddress(server) : this.toDriver.containerInfinispanServerDriver.getServerAddress(server);
        try {
            this.memcachedClients[server] = new MemcachedClient(builder.build(), Collections.singletonList(InetSocketAddress.createUnresolved(address.getHostAddress(), 11222)));
            return this.memcachedClients[server];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public STATE getCurrentState() {
        return this.currentState;
    }

    public static RollingUpgradeHandler runUntilMixed(RollingUpgradeConfiguration configuration) throws InterruptedException {
        RollingUpgradeHandler handler = new RollingUpgradeHandler(configuration);
        try {
            log.debugf("Starting %d nodes to version %s in cluster %s", handler.nodeCount, (Object)handler.versionFrom, (Object)handler.clusterName);
            handler.fromDriver = handler.startNode(false, configuration.nodeCount(), configuration.nodeCount(), handler.clusterName, configuration.jgroupsProtocol(), null, configuration.serverConfigurationFile(), configuration.defaultServerConfigurationFile(), configuration.customArtifacts(), configuration.mavenArtifacts(), configuration.properties(), configuration.listeners());
            handler.currentState = STATE.OLD_RUNNING;
            configuration.initialHandler().accept(handler);
            handler.removeOldAndAddNew(handler.clusterName);
            handler.currentState = STATE.NEW_RUNNING;
        }
        catch (Throwable t) {
            try {
                handler.exceptionEncountered(t);
                throw t;
            }
            catch (Throwable throwable) {
                handler.cleanup();
                throw throwable;
            }
        }
        return handler;
    }

    private void removeOldAndAddNew(String site1Name) throws InterruptedException {
        log.debugf("Shutting down 1 node from version: %s for cluster %s", (Object)this.versionFrom, (Object)this.clusterName);
        int nodeId = this.nodeLeft-- - 1;
        String volumeId = this.fromDriver.containerInfinispanServerDriver.volumeId(nodeId);
        this.fromDriver.containerInfinispanServerDriver.stop(nodeId);
        this.cleanup(nodeId);
        this.currentState = STATE.REMOVED_OLD;
        if (!RollingUpgradeHandler.ensureServersWorking(this, this.nodeCount - 1)) {
            if (log.isDebugEnabled() && this.remoteCacheManager != null) {
                log.debugf("Servers are: %s", (Object)Arrays.toString(this.remoteCacheManager.getServers()));
            }
            throw new IllegalStateException("Servers did not shut down properly within 30 seconds, assuming error");
        }
        log.debugf("Starting 1 node to version %s at cluster %s", (Object)this.versionTo, (Object)this.clusterName);
        if (this.toDriver == null) {
            this.toDriver = this.startNode(true, 1, this.nodeCount, site1Name, this.configuration.jgroupsProtocol(), volumeId, this.configuration.serverConfigurationFile(), this.configuration.defaultServerConfigurationFile(), this.configuration.customArtifacts(), this.configuration.mavenArtifacts(), this.configuration.properties(), this.configuration.listeners());
        } else {
            this.toDriver.containerInfinispanServerDriver.startAdditionalServer(this.nodeCount, volumeId);
        }
        this.currentState = STATE.ADDED_NEW;
        if (!RollingUpgradeHandler.ensureServersWorking(this, this.nodeCount)) {
            if (log.isDebugEnabled() && this.remoteCacheManager != null) {
                log.debugf("Servers are: %s", (Object)Arrays.toString(this.remoteCacheManager.getServers()));
            }
            throw new IllegalStateException("Servers did not cluster within 30 seconds, assuming error");
        }
    }

    public void complete() {
        try {
            while (this.nodeLeft > 0) {
                this.removeOldAndAddNew(this.clusterName);
                this.currentState = STATE.NEW_RUNNING;
            }
        }
        catch (Throwable e) {
            this.exceptionEncountered(e);
        }
        finally {
            this.cleanup();
        }
    }

    public void exceptionEncountered(Throwable t) {
        this.currentState = STATE.ERROR;
        this.configuration.exceptionHandler().accept(t, this);
    }

    public static void performUpgrade(RollingUpgradeConfiguration configuration) throws InterruptedException {
        RollingUpgradeHandler ruh = RollingUpgradeHandler.runUntilMixed(configuration);
        try {
            ruh.complete();
        }
        catch (Throwable t) {
            ruh.exceptionEncountered(t);
        }
        finally {
            ruh.cleanup();
        }
    }

    private static boolean ensureServersWorking(RollingUpgradeHandler handler, int expectedCount) throws InterruptedException {
        long begin = System.nanoTime();
        while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - begin) < (long)handler.configuration.serverCheckTimeSecs()) {
            log.debugf("Checking to ensure cluster formed properly, expecting %d servers", expectedCount);
            if (handler.configuration.isValidServerState().test(handler)) {
                return true;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        }
        log.debugf("Cluster state check timed out after %d secs, check for possible issues", handler.configuration.serverCheckTimeSecs());
        return false;
    }

    private void cleanup() {
        if (this.fromDriver != null) {
            this.fromDriver.containerInfinispanServerDriver.stop(this.configuration.fromVersion());
        }
        if (this.toDriver != null) {
            this.toDriver.containerInfinispanServerDriver.stop(this.configuration.toVersion());
        }
        Util.close((AutoCloseable)this.remoteCacheManager);
        Arrays.stream(this.restClients).forEach(Util::close);
        Arrays.stream(this.memcachedClients).forEach(c -> {
            if (c != null) {
                c.shutdown();
            }
        });
        Util.close((AutoCloseable)this.respClient);
    }

    private void cleanup(int server) {
        Util.close((AutoCloseable)this.restClients[server]);
        this.restClients[server] = null;
        if (this.memcachedClients[server] != null) {
            this.memcachedClients[server].shutdown();
            this.memcachedClients[server] = null;
        }
    }

    private RemoteCacheManager createRemoteCacheManager() {
        assert (this.currentState == STATE.OLD_RUNNING);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(1).connectionPool().maxActive(1);
        if (OS.getCurrentOs().equals((Object)OS.MAC_OS) || OS.getCurrentOs().equals((Object)OS.WINDOWS)) {
            builder.clientIntelligence(ClientIntelligence.BASIC);
        }
        if (this.fromDriver.infinispanServerTestConfiguration.isDefaultFile()) {
            TestUser user = TestUser.ADMIN;
            builder.security().authentication().username(user.getUser()).password(user.getPassword());
        }
        builder = this.configuration.configurationHandler().apply(builder);
        for (int i = 0; i < this.fromDriver.infinispanServerTestConfiguration.numServers(); ++i) {
            InetSocketAddress address = this.fromDriver.containerInfinispanServerDriver.getServerSocket(i, 11222);
            builder.addServer().host(address.getHostString()).port(address.getPort());
        }
        return this.fromDriver.containerInfinispanServerDriver.createRemoteCacheManager(builder);
    }

    private ConfigAndDriver startNode(boolean toOrFrom, int nodeCount, int expectedCount, String clusterName, String protocol, String volumeId, String serverConfigurationFile, boolean defaultServerConfigurationFile, JavaArchive[] artifacts, String[] mavenArtifacts, Properties properties, List<InfinispanServerListener> listeners) {
        ServerConfigBuilder builder = new ServerConfigBuilder(serverConfigurationFile, defaultServerConfigurationFile);
        builder.runMode(ServerRunMode.CONTAINER);
        builder.numServers(nodeCount);
        builder.expectedServers(expectedCount);
        builder.clusterName(clusterName);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k instanceof String && v instanceof String) {
                builder.property((String)k, (String)v);
            }
        }));
        builder.artifacts(artifacts);
        builder.mavenArtifacts(mavenArtifacts);
        builder.property("infinispan.cluster.stack", protocol);
        listeners.forEach(builder::addListener);
        builder.property("org.infinispan.test.server.requireJoinTimeout", Boolean.toString(nodeCount != expectedCount));
        if (this.configuration.useSharedDataMount()) {
            builder.property("org.infinispan.test.server.container.volume", "true");
        }
        String versionToUse = toOrFrom ? this.configuration.toVersion() : this.configuration.fromVersion();
        String name = clusterName + "-" + versionToUse;
        if (versionToUse.startsWith("image://")) {
            builder.property("org.infinispan.test.server.container.baseImageName", versionToUse.substring("image://".length()));
        } else if (versionToUse.startsWith("file://")) {
            String imageName;
            builder.property("org.infinispan.test.server.dir", versionToUse.substring("file://".length()));
            versionToUse = Path.of(versionToUse, new String[0]).getFileName().toString();
            if (toOrFrom) {
                assert (this.toImageCreated == null);
                this.toImageCreated = versionToUse.toLowerCase() + "-to";
                imageName = this.toImageCreated;
            } else {
                assert (this.fromImageCreated == null);
                this.fromImageCreated = versionToUse.toLowerCase() + "-from";
                imageName = this.fromImageCreated;
            }
            builder.property("org.infinispan.test.server.container.snapshotImageName", imageName);
        } else {
            builder.property("org.infinispan.test.server.version", versionToUse);
        }
        InfinispanServerTestConfiguration config = builder.createServerTestConfiguration();
        ContainerInfinispanServerDriver driver = (ContainerInfinispanServerDriver)ServerRunMode.CONTAINER.newDriver(config);
        driver.prepare(name);
        listeners.forEach(l -> l.before(driver));
        if (volumeId != null) {
            if (nodeCount != 1) {
                throw new IllegalArgumentException("nodeCount " + nodeCount + " must be 1 when a volumeId is passed " + volumeId);
            }
            driver.configureImage(name);
            driver.startAdditionalServer(expectedCount, volumeId);
        } else {
            driver.start(name);
        }
        return new ConfigAndDriver(config, driver);
    }

    public static enum STATE {
        NOT_STARTED,
        OLD_RUNNING,
        REMOVED_OLD,
        ADDED_NEW,
        NEW_RUNNING,
        ERROR;

    }

    record ConfigAndDriver(InfinispanServerTestConfiguration infinispanServerTestConfiguration, ContainerInfinispanServerDriver containerInfinispanServerDriver) {
    }
}

