/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.persistence;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.persistence.Database;
import org.jboss.logging.Logger;

public class DatabaseServerListener
implements InfinispanServerListener {
    private static final Logger log = Logger.getLogger(DatabaseServerListener.class);
    private static final String DATABASE_PROPERTIES = "org.infinispan.server.test.database.%s.%s";
    private final String[] databaseTypes;
    public Map<String, Database> databases;

    public DatabaseServerListener(String ... databaseTypes) {
        String property = System.getProperty("org.infinispan.test.database.types");
        if (property != null) {
            this.databaseTypes = property.split(",");
            log.infof("Overriding databases: %s", (Object[])this.databaseTypes);
        } else {
            this.databaseTypes = databaseTypes;
        }
    }

    @Override
    public void before(InfinispanServerDriver driver) {
        this.databases = new LinkedHashMap<String, Database>(this.databaseTypes.length);
        for (String dbType : this.databaseTypes) {
            Database database = this.initDatabase(dbType);
            log.infof("Starting database: %s", (Object)database.getType());
            database.start();
            log.infof("Started database: %s", (Object)database.getType());
            if (this.databases.putIfAbsent(dbType, database) != null) {
                throw new RuntimeException("Duplicate database type " + dbType);
            }
            this.addDbProperty(driver, database, "jdbcUrl", database.jdbcUrl());
            this.addDbProperty(driver, database, "username", database.username());
            this.addDbProperty(driver, database, "password", database.password());
            this.addDbProperty(driver, database, "driver", database.driverClassName());
        }
    }

    @Override
    public void after(InfinispanServerDriver driver) {
        log.info((Object)"Stopping databases");
        this.databases.values().forEach(Database::stop);
        log.info((Object)"Stopped databases");
    }

    public Database getDatabase(String databaseType) {
        return this.databases.get(databaseType);
    }

    public String[] getDatabaseTypes() {
        return this.databaseTypes;
    }

    private Database initDatabase(String databaseType) {
        Database database;
        block8: {
            String property = System.getProperty("org.infinispan.test.database.properties.path");
            InputStream inputStream = property != null ? Files.newInputStream(Paths.get(property, new String[0]).resolve(databaseType + ".properties"), new OpenOption[0]) : this.getClass().getResourceAsStream(String.format("/database/%s.properties", databaseType));
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                database = Database.fromProperties(databaseType, properties);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return database;
    }

    private void addDbProperty(InfinispanServerDriver driver, Database database, String parameterProperty, String dbProperty) {
        driver.getConfiguration().properties().put(String.format(DATABASE_PROPERTIES, database.getType(), parameterProperty), dbProperty);
    }
}

