/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.BaseDevice;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.terminal.utils.Config;
import org.infinispan.commons.test.Eventually;
import org.junit.ComparisonFailure;

public class AeshTestConnection
implements Connection,
AutoCloseable {
    private Consumer<Size> sizeHandler;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> stdinHandler;
    private final Consumer<int[]> stdOutHandler;
    private Consumer<Void> closeHandler;
    private final StringBuilder bufferBuilder = new StringBuilder();
    private final Size size;
    private Attributes attributes;
    private volatile boolean reading = false;

    public AeshTestConnection() {
        this(new Size(80, 20), true);
    }

    public AeshTestConnection(boolean stripAnsiCodes) {
        this(new Size(80, 20), stripAnsiCodes);
    }

    public AeshTestConnection(Size size) {
        this(size, true);
    }

    public AeshTestConnection(Size size, boolean stripAnsiCodes) {
        this.stdOutHandler = ints -> {
            if (stripAnsiCodes) {
                this.bufferBuilder.append(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
            } else {
                this.bufferBuilder.append(Parser.fromCodePoints((int[])ints));
            }
        };
        this.size = size == null ? new Size(80, 20) : size;
        this.attributes = new Attributes();
    }

    public void clear() {
        if (this.bufferBuilder.length() > 0) {
            this.bufferBuilder.delete(0, this.bufferBuilder.length());
        }
    }

    public String getOutputBuffer() {
        return this.bufferBuilder.toString();
    }

    public Device device() {
        return new BaseDevice(){

            public String type() {
                return "vt100";
            }

            public boolean getBooleanCapability(Capability capability) {
                return false;
            }

            public Integer getNumericCapability(Capability capability) {
                return null;
            }

            public String getStringCapability(Capability capability) {
                return null;
            }
        };
    }

    public Size size() {
        return this.size;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.signalHandler = handler;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.stdinHandler = handler;
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdOutHandler;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    @Override
    public void close() {
        if (this.reading) {
            this.send("disconnect");
        }
        this.reading = false;
        if (this.closeHandler != null) {
            this.closeHandler.accept(null);
        }
    }

    public boolean closed() {
        return !this.reading;
    }

    public void openBlocking() {
        this.reading = true;
    }

    public void openNonBlocking() {
    }

    private void doSend(String input) {
        this.doSend(Parser.toCodePoints((String)input));
    }

    private void doSend(int[] input) {
        if (this.reading) {
            if (this.stdinHandler != null) {
                this.stdinHandler.accept(input);
            } else {
                try {
                    Thread.sleep(10L);
                    this.doSend(input);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("Got input when not reading: " + Arrays.toString(input));
        }
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Charset inputEncoding() {
        return Charset.defaultCharset();
    }

    public Charset outputEncoding() {
        return Charset.defaultCharset();
    }

    public boolean supportsAnsi() {
        return true;
    }

    public void assertEquals(String expected) {
        Eventually.eventually(() -> new ComparisonFailure("Expected output was not equal to expected string after timeout", expected, this.bufferBuilder.toString()), () -> expected.equals(this.bufferBuilder.toString()), (long)10000L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void send(String data) {
        this.doSend(data + Config.getLineSeparator());
    }

    public void assertContains(String expected) {
        Eventually.eventually(() -> new ComparisonFailure("Expected output did not contain expected string after timeout", expected, this.bufferBuilder.toString()), () -> this.bufferBuilder.toString().contains(expected), (long)10000L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void assertNotContains(String unexpected) {
        Eventually.eventually(() -> new ComparisonFailure("Expected output should not contain expected string after timeout", unexpected, this.bufferBuilder.toString()), () -> !this.bufferBuilder.toString().contains(unexpected), (long)10000L, (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

