/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import java.io.Closeable;
import org.infinispan.server.test.api.BaseTestClientDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class RespTestClientDriver
extends BaseTestClientDriver<RespTestClientDriver> {
    private final TestServer testServer;
    private final TestClient testClient;
    private Vertx vertx;
    private RedisOptions options;

    public RespTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
    }

    public RespTestClientDriver self() {
        return this;
    }

    public RespTestClientDriver withOptions(RedisOptions options) {
        this.options = options;
        return this;
    }

    public RespTestClientDriver withVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public Redis get() {
        RespVertxClient client = new RespVertxClient(this.options, this.vertx);
        this.testClient.registerResource(client);
        return client.get();
    }

    public RedisConnection connect(Redis client) {
        RedisConnection conn = (RedisConnection)client.connect().result();
        this.testClient.registerResource(() -> ((RedisConnection)conn).close());
        return conn;
    }

    public RedisConnection getConnection() {
        return this.connect(this.get());
    }

    private static class RespVertxClient
    extends AbstractVerticle
    implements Closeable {
        private final RedisOptions options;
        private Redis client;

        private RespVertxClient(RedisOptions options, Vertx vertx) {
            this.options = options;
            this.vertx = vertx;
        }

        private Redis get() {
            assert (this.client == null) : "Vertx Redis client already created";
            this.client = Redis.createClient((Vertx)this.vertx, (RedisOptions)this.options);
            return this.client;
        }

        @Override
        public void close() {
            if (this.client != null) {
                this.client.close();
            }
        }
    }
}

