/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.OS;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.BaseTestClientDriver;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class HotRodTestClientDriver
extends BaseTestClientDriver<HotRodTestClientDriver> {
    private final TestServer testServer;
    private final TestClient testClient;
    private ConfigurationBuilder clientConfiguration;
    private int port = 11222;

    public HotRodTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.maxRetries(1).connectionPool().maxActive(1);
        this.applyDefaultConfiguration(builder);
        if (OS.getCurrentOs().equals((Object)OS.MAC_OS) || OS.getCurrentOs().equals((Object)OS.WINDOWS)) {
            builder.clientIntelligence(ClientIntelligence.BASIC);
        }
        this.clientConfiguration = builder;
    }

    public HotRodTestClientDriver withClientConfiguration(ConfigurationBuilder clientConfiguration) {
        this.clientConfiguration = this.applyDefaultConfiguration(clientConfiguration);
        return this;
    }

    public HotRodTestClientDriver withClientConfiguration(ClientIntelligence clientIntelligence) {
        this.clientConfiguration.clientIntelligence(clientIntelligence);
        return this;
    }

    public HotRodTestClientDriver withClientConfiguration(Properties properties) {
        this.clientConfiguration.withProperties(properties);
        return this;
    }

    public HotRodTestClientDriver withMarshaller(Class<? extends Marshaller> marshallerClass) {
        this.clientConfiguration.marshaller(marshallerClass);
        return this;
    }

    public HotRodTestClientDriver withPort(int port) {
        this.port = port;
        return this;
    }

    public <K, V> RemoteCache<K, V> get() {
        RemoteCacheManager remoteCacheManager = this.createRemoteCacheManager();
        String name = this.testClient.getMethodName(this.qualifiers);
        return remoteCacheManager.getCache(name);
    }

    public <K, V> RemoteCache<K, V> get(String name) {
        RemoteCacheManager remoteCacheManager = this.createRemoteCacheManager();
        return remoteCacheManager.getCache(name);
    }

    public <K, V> RemoteCache<K, V> create() {
        return this.create(-1);
    }

    public <K, V> RemoteCache<K, V> create(int index) {
        RemoteCacheManager remoteCacheManager = index >= 0 ? this.createRemoteCacheManager(index) : this.createRemoteCacheManager();
        String name = this.testClient.getMethodName(this.qualifiers);
        RemoteCache remoteCache = this.serverConfiguration != null ? ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, this.serverConfiguration) : (this.mode != null ? ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + this.mode.name()) : ((RemoteCacheManagerAdmin)remoteCacheManager.administration().withFlags(this.flags)).getOrCreateCache(name, "org.infinispan." + CacheMode.DIST_SYNC.name()));
        this.testClient.registerHotRodCache(name, remoteCacheManager);
        return remoteCache;
    }

    public RemoteCacheManager createRemoteCacheManager() {
        return this.testClient.registerResource(this.testServer.newHotRodClient(this.clientConfiguration, this.port));
    }

    public RemoteCacheManager createRemoteCacheManager(int index) {
        return this.testClient.registerResource(this.testServer.newHotRodClient(this.clientConfiguration, this.port, index));
    }

    public HotRodTestClientDriver self() {
        return this;
    }

    private ConfigurationBuilder applyDefaultConfiguration(ConfigurationBuilder builder) {
        if (this.testServer.isContainerRunWithDefaultServerConfig()) {
            builder.security().authentication().username(TestUser.ADMIN.getUser()).password(TestUser.ADMIN.getPassword());
        }
        return builder;
    }
}

