/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.test.api.BaseTestClientDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class RestTestClientDriver
extends BaseTestClientDriver<RestTestClientDriver> {
    public static final int TIMEOUT = Integer.getInteger("org.infinispan.test.server.http.timeout", 10);
    private RestClientConfigurationBuilder clientConfiguration = new RestClientConfigurationBuilder();
    private TestServer testServer;
    private TestClient testClient;
    private int port = 11222;

    public RestTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
    }

    public RestTestClientDriver withClientConfiguration(RestClientConfigurationBuilder clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public RestTestClientDriver withPort(int port) {
        this.port = port;
        return this;
    }

    public RestClient get() {
        return this.testClient.registerResource(this.testServer.newRestClient(this.clientConfiguration, this.port));
    }

    public RestClient get(int n) {
        return this.testClient.registerResource(this.testServer.newRestClientForServer(this.clientConfiguration, this.port, n));
    }

    public RestClient create() {
        CompletionStage future;
        RestClient restClient = this.get();
        String name = this.testClient.getMethodName(this.qualifier);
        if (this.serverConfiguration != null) {
            RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)this.serverConfiguration.toStringConfiguration(name));
            future = restClient.cache(name).createWithConfiguration(configEntity, this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
        } else {
            future = this.mode != null ? restClient.cache(name).createWithTemplate("org.infinispan." + this.mode, this.flags.toArray(new CacheContainerAdmin.AdminFlag[0])) : restClient.cache(name).createWithTemplate("org.infinispan.DIST_SYNC", this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
        }
        RestResponse response = (RestResponse)Exceptions.unchecked(() -> (RestResponse)future.toCompletableFuture().get(TIMEOUT, TimeUnit.SECONDS));
        response.close();
        if (response.getStatus() != 200) {
            switch (response.getStatus()) {
                case 400: {
                    throw new IllegalArgumentException("Bad request while attempting to obtain rest client: " + response.getStatus());
                }
                case 401: 
                case 403: {
                    throw new SecurityException("Authentication error while attempting to obtain rest client = " + response.getStatus());
                }
            }
            throw new RuntimeException("Could not obtain rest client = " + response.getStatus());
        }
        if (restClient.getConfiguration().security().authentication().enabled() && !response.usedAuthentication()) {
            throw new SecurityException("Authentication expected but anonymous access succeeded");
        }
        return restClient;
    }

    public RestTestClientDriver self() {
        return this;
    }
}

