/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import java.util.EnumSet;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.StringConfiguration;

abstract class BaseTestClientDriver<S extends BaseTestClientDriver<S>>
implements Self<S> {
    protected BasicConfiguration serverConfiguration = null;
    protected EnumSet<CacheContainerAdmin.AdminFlag> flags = EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class);
    protected String mode = null;
    protected String qualifier;

    BaseTestClientDriver() {
    }

    public S withServerConfiguration(BasicConfiguration serverConfiguration) {
        if (this.mode != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.serverConfiguration = serverConfiguration;
        return (S)((BaseTestClientDriver)this.self());
    }

    public S withServerConfiguration(StringConfiguration configuration) {
        if (this.mode != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.serverConfiguration = configuration;
        return (S)((BaseTestClientDriver)this.self());
    }

    public S withCacheMode(Enum<?> mode) {
        if (this.serverConfiguration != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.mode = mode.name();
        return (S)((BaseTestClientDriver)this.self());
    }

    public S withCacheMode(String mode) {
        if (this.serverConfiguration != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.mode = mode;
        return (S)((BaseTestClientDriver)this.self());
    }

    public S withQualifier(String qualifier) {
        this.qualifier = qualifier;
        return (S)((BaseTestClientDriver)this.self());
    }

    public S makeVolatile() {
        this.flags = EnumSet.of(CacheContainerAdmin.AdminFlag.VOLATILE);
        return (S)((BaseTestClientDriver)this.self());
    }
}

