/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanGenericContainer;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.testcontainers.DockerClientFactory;

public class TestServer {
    protected InfinispanServerDriver serverDriver;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();
    protected InfinispanServerTestConfiguration configuration;

    public TestServer(InfinispanServerTestConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isDriverInitialized() {
        return this.serverDriver != null;
    }

    public InfinispanServerDriver getDriver() {
        if (this.serverDriver == null) {
            throw new IllegalStateException("ServerDriver is null. Server driver not initialized");
        }
        return this.serverDriver;
    }

    public void stopServerDriver(String testName) {
        this.getDriver().stop(testName);
        this.serverDriver = null;
    }

    public RemoteCacheManager newHotRodClient() {
        return this.newHotRodClient(new ConfigurationBuilder());
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder) {
        return this.newHotRodClient(builder, 11222);
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder, int port) {
        block4: {
            if (!builder.servers().isEmpty()) break block4;
            if (this.getDriver().getConfiguration().runMode() == ServerRunMode.CONTAINER) {
                ContainerInfinispanServerDriver containerDriver = (ContainerInfinispanServerDriver)this.serverDriver;
                for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                    InfinispanGenericContainer container = containerDriver.getContainer(0);
                    String hostIpAddress = DockerClientFactory.instance().dockerHostIpAddress();
                    builder.addServer().host(hostIpAddress).port(container.getMappedPort(port));
                }
            } else {
                for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                    InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, port);
                    builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
                }
            }
        }
        return this.getDriver().createRemoteCacheManager(builder);
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder) {
        return this.newRestClient(builder, 11222);
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder, int port) {
        for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, port);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    CloseableMemcachedClient newMemcachedClient() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress unresolved = this.getDriver().getServerSocket(i, 11221);
            addresses.add(new InetSocketAddress(unresolved.getHostName(), unresolved.getPort()));
        }
        MemcachedClient memcachedClient = (MemcachedClient)Exceptions.unchecked(() -> new MemcachedClient(addresses));
        return new CloseableMemcachedClient(memcachedClient);
    }

    public void beforeListeners() {
        this.configuration.listeners().forEach(l -> l.before(this.serverDriver));
    }

    public void afterListeners() {
        this.configuration.listeners().forEach(l -> l.after(this.serverDriver));
    }

    public boolean isContainerRunWithDefaultServerConfig() {
        return this.configuration.isDefaultFile() && this.configuration.runMode() == ServerRunMode.CONTAINER;
    }

    public RestClient newRestClientForServer(RestClientConfigurationBuilder builder, int port, int n) {
        InetSocketAddress serverAddress = this.getDriver().getServerSocket(n, port);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    public void add(Consumer<File> enhancer) {
        this.configurationEnhancers.add(enhancer);
    }

    public void initServerDriver() {
        this.serverDriver = this.configuration.runMode().newDriver(this.configuration);
    }

    public void enhanceConfiguration() {
        this.configurationEnhancers.forEach(c -> c.accept(this.serverDriver.getConfDir()));
    }

    public boolean hasCrossSiteEnabled() {
        return this.configuration.site() != null;
    }

    public String getSiteName() {
        return this.configuration.site();
    }

    public static class CloseableMemcachedClient
    implements Closeable {
        final MemcachedClient client;

        public CloseableMemcachedClient(MemcachedClient client) {
            this.client = client;
        }

        public MemcachedClient getClient() {
            return this.client;
        }

        @Override
        public void close() {
            this.client.shutdown();
        }
    }
}

