/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public abstract class AbstractServerConfigBuilder<T extends AbstractServerConfigBuilder<T>> {
    private final String configurationFile;
    private final boolean defaultFile;
    private final Properties properties;
    private String[] mavenArtifacts;
    private int numServers = 2;
    private ServerRunMode runMode = ServerRunMode.DEFAULT;
    private JavaArchive[] archives;
    private boolean jmx;
    private boolean parallelStartup = true;
    private final List<InfinispanServerListener> listeners = new ArrayList<InfinispanServerListener>();
    private String siteName;
    private int portOffset = 0;

    protected AbstractServerConfigBuilder(String configurationFile, boolean defaultFile) {
        this.configurationFile = configurationFile;
        this.defaultFile = defaultFile;
        this.properties = new Properties();
        Properties sysProps = System.getProperties();
        for (String prop : sysProps.stringPropertyNames()) {
            if (!prop.startsWith("org.infinispan")) continue;
            this.properties.put(prop, sysProps.getProperty(prop));
        }
    }

    public InfinispanServerTestConfiguration createServerTestConfiguration() {
        return new InfinispanServerTestConfiguration(this.configurationFile, this.numServers, this.runMode, this.properties, this.mavenArtifacts, this.archives, this.jmx, this.parallelStartup, this.defaultFile, this.listeners, this.siteName, this.portOffset);
    }

    public T mavenArtifacts(String ... mavenArtifacts) {
        this.mavenArtifacts = mavenArtifacts;
        return (T)this;
    }

    public T numServers(int numServers) {
        this.numServers = numServers;
        return (T)this;
    }

    public T runMode(ServerRunMode serverRunMode) {
        this.runMode = serverRunMode;
        return (T)this;
    }

    public T addListener(InfinispanServerListener listener) {
        this.listeners.add(listener);
        return (T)this;
    }

    public T artifacts(JavaArchive ... archives) {
        this.archives = archives;
        return (T)this;
    }

    public T property(String name, String value) {
        this.properties.setProperty(name, value);
        return (T)this;
    }

    public T enableJMX() {
        this.jmx = true;
        return (T)this;
    }

    public T parallelStartup(boolean parallel) {
        this.parallelStartup = parallel;
        return (T)this;
    }

    public T site(String site) {
        this.siteName = site;
        return (T)this;
    }

    public T portOffset(int port) {
        this.portOffset = port;
        return (T)this;
    }
}

