/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestServer;

public class TestClient {
    protected InfinispanServerTestConfiguration configuration;
    protected TestServer testServer;
    protected List<Closeable> resources;
    private String methodName;

    public TestClient(TestServer testServer) {
        this.testServer = testServer;
    }

    public <T extends Closeable> T registerResource(T resource) {
        this.resources.add(resource);
        return resource;
    }

    public InfinispanServerDriver getServerDriver() {
        if (!this.testServer.isDriverInitialized()) {
            throw new IllegalStateException("Operation not supported before test starts");
        }
        return this.testServer.getDriver();
    }

    public HotRodTestClientDriver hotrod() {
        return new HotRodTestClientDriver(this.testServer, this);
    }

    public RestTestClientDriver rest() {
        return new RestTestClientDriver(this.testServer, this);
    }

    public CounterManager getCounterManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.testServer.newHotRodClient());
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)remoteCacheManager);
    }

    public <K, V> MultimapCacheManager<K, V> getRemoteMultimapCacheManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.testServer.newHotRodClient());
        return RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)remoteCacheManager);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void clearResources() {
        if (this.resources != null) {
            this.resources.forEach(Util::close);
            this.resources.clear();
        }
    }

    public void initResources() {
        this.resources = new ArrayList<Closeable>();
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
            scriptCache.put((Object)this.getMethodName(), (Object)CommonsTestingUtil.loadFileAsString((InputStream)in));
        }
        catch (HotRodClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getMethodName();
    }

    public String getMethodName() {
        return this.getMethodName(null);
    }

    public RestClient newRestClient(RestClientConfigurationBuilder restClientConfigurationBuilder) {
        RestClient restClient = this.testServer.newRestClient(restClientConfigurationBuilder);
        this.registerResource(restClient);
        return restClient;
    }

    public String getMethodName(String qualifier) {
        String cacheName = "C" + this.methodName + (qualifier != null ? qualifier : "");
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1.digest(cacheName.getBytes(StandardCharsets.UTF_8));
            return Util.toHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public MemcachedClient getMemcachedClient() {
        return this.registerResource(this.testServer.newMemcachedClient()).getClient();
    }
}

