/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.OS;
import org.infinispan.server.test.core.ForkedInfinispanServerDriver;

public class ForkedServer {
    public static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.container.timeoutSeconds", 30);
    public static final Integer DEFAULT_SINGLE_PORT = 11222;
    public static final int OFFSET_FACTOR = 100;
    private static final Log log = LogFactory.getLog(ForkedInfinispanServerDriver.class);
    private static final String START_PATTERN = "ISPN080001";
    private final List<String> commands = new ArrayList<String>();
    private final UUID serverId = UUID.randomUUID();
    private Process process;
    private Process serverLogProcess;
    private final String serverHome;
    private final String serverLogDir;
    private final String serverLog;
    private String jvmOptions;

    public ForkedServer(String serverHome) {
        this.serverHome = serverHome;
        this.serverLogDir = serverHome + File.separator + "server" + File.separator + "log";
        this.serverLog = this.serverLogDir + File.separator + "server.log";
        this.cleanServerLog();
        this.callInitScript();
    }

    private void callInitScript() {
        String extension = OS.getCurrentOs() == OS.WINDOWS ? ".bat" : ".sh";
        this.commands.add(this.serverHome + File.separator + "bin" + File.separator + "server" + extension);
        this.commands.add(String.format("-D%s-pid=%s", this.getClass().getName(), this.serverId));
    }

    public ForkedServer setServerConfiguration(String serverConfiguration) {
        this.commands.add("-c");
        if (!new File(serverConfiguration).isAbsolute()) {
            serverConfiguration = this.getClass().getClassLoader().getResource(serverConfiguration).getPath();
        }
        this.commands.add(serverConfiguration);
        return this;
    }

    public ForkedServer setPortsOffset(int numServer) {
        if (numServer >= 1) {
            this.commands.add("-o");
            this.commands.add(String.valueOf(100 * numServer));
        }
        return this;
    }

    public ForkedServer setJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return this;
    }

    public ForkedServer start() {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(this.commands);
        if (this.jvmOptions != null) {
            pb.environment().put("JAVA_OPTS", this.jvmOptions);
        }
        try {
            this.process = pb.start();
            boolean isServerStarted = this.runWithTimeout(this::checkServerLog, START_PATTERN);
            if (!isServerStarted) {
                throw new IllegalStateException("The server couldn't start");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return this;
    }

    public boolean runWithTimeout(Function<String, Boolean> function, String logPattern) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Callable<Boolean> task = () -> (Boolean)function.apply(logPattern);
        Future<Boolean> future = executor.submit(task);
        return (Boolean)Exceptions.unchecked(() -> (Boolean)future.get(TIMEOUT_SECONDS, TimeUnit.SECONDS));
    }

    private boolean checkServerLog(String pattern) {
        return (Boolean)Exceptions.unchecked(() -> {
            this.serverLogProcess = Runtime.getRuntime().exec(String.format("tail -f %s", this.serverLog));
            try (Stream<String> lines = new BufferedReader(new InputStreamReader(this.process.getInputStream())).lines();){
                Boolean bl = lines.peek(System.out::println).anyMatch(line -> line.contains(pattern));
                return bl;
            }
        });
    }

    public void cleanup() {
        this.serverLogProcess.destroy();
    }

    public void printServerLog(Consumer<String> c) {
        try (Stream<String> s = Files.lines(Paths.get(this.serverLog, new String[0]));){
            s.forEach(c);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanServerLog() {
        Exceptions.unchecked(() -> {
            Files.deleteIfExists(Paths.get(this.serverLog, new String[0]));
            boolean isServerLogDirectoryExist = Files.exists(Paths.get(this.serverLogDir, new String[0]), new LinkOption[0]);
            if (!isServerLogDirectoryExist) {
                Files.createDirectory(Paths.get(this.serverLogDir, new String[0]), new FileAttribute[0]);
            }
            Files.createFile(Paths.get(this.serverLog, new String[0]), new FileAttribute[0]);
        });
    }

    public File getServerLib() {
        return Paths.get(this.serverHome + File.separator + "server" + File.separator + "lib", new String[0]).toFile();
    }

    public long getPid() {
        try {
            String psLine;
            Process psProcess = Runtime.getRuntime().exec("ps");
            BufferedReader input = new BufferedReader(new InputStreamReader(psProcess.getInputStream()));
            while ((psLine = input.readLine()) != null) {
                if (!psLine.contains(this.serverId.toString()) || !psLine.contains("bin" + File.separator + "java")) continue;
                psProcess.destroyForcibly();
                long pid = Long.parseLong(psLine.substring(0, psLine.indexOf(" ")));
                log.infof("Obtained pid is %d for process %s.", (Object)pid, (Object)this.serverId);
                return pid;
            }
            input.close();
            this.process.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedOperationException();
    }
}

