/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.security.auth.x500.X500Principal;
import org.infinispan.cli.user.UserTool;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.wildfly.security.x500.cert.BasicConstraintsExtension;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;

public abstract class AbstractInfinispanServerDriver
implements InfinispanServerDriver {
    public static final String DEFAULT_CLUSTERED_INFINISPAN_CONFIG_FILE_NAME = "infinispan.xml";
    public static final String TEST_HOST_ADDRESS = "org.infinispan.test.host.address";
    public static final String BASE_DN = "CN=%s,OU=Infinispan,O=JBoss,L=Red Hat";
    public static final String KEY_PASSWORD = "secret";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String KEYSTORE_TYPE = "pkcs12";
    protected final InfinispanServerTestConfiguration configuration;
    protected final InetAddress testHostAddress;
    private File rootDir;
    private File confDir;
    private ComponentStatus status;
    private final AtomicLong certSerial = new AtomicLong(1L);

    protected AbstractInfinispanServerDriver(InfinispanServerTestConfiguration configuration, InetAddress testHostAddress) {
        this.configuration = configuration;
        this.testHostAddress = testHostAddress;
        this.status = ComponentStatus.INSTANTIATED;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.status;
    }

    @Override
    public InfinispanServerTestConfiguration getConfiguration() {
        return this.configuration;
    }

    protected abstract void start(String var1, File var2, File var3);

    protected String debugJvmOption() {
        String nonLoopbackAddress;
        try {
            nonLoopbackAddress = NetworkAddress.nonLoopback((String)"").getAddress().getHostAddress();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not find a non-loopback address");
        }
        return String.format("-agentlib:jdwp=transport=dt_socket,server=n,address=%s:5005", nonLoopbackAddress);
    }

    protected abstract void stop();

    @Override
    public void prepare(String name) {
        String siteName = this.configuration.site() == null ? "" : this.configuration.site();
        String testDir = CommonsTestingUtil.tmpDirectory((String[])new String[]{siteName + name});
        Util.recursiveFileRemove((String)testDir);
        this.rootDir = new File(testDir);
        this.confDir = new File(this.rootDir, "conf");
        if (!this.confDir.mkdirs()) {
            throw new RuntimeException("Failed to create server configuration directory " + this.confDir);
        }
        if (!this.configuration.isDefaultFile()) {
            this.copyProvidedServerConfigurationFile();
        }
        this.createUserFile("default");
        this.createKeyStores();
    }

    @Override
    public void start(String name) {
        this.status = ComponentStatus.INITIALIZING;
        try {
            log.infof("Starting server %s", (Object)name);
            this.start(name, this.rootDir, new File(this.configuration.configurationFile()));
            log.infof("Started server %s", (Object)name);
            this.status = ComponentStatus.RUNNING;
        }
        catch (Throwable t) {
            this.status = ComponentStatus.FAILED;
            throw t;
        }
    }

    @Override
    public final void stop(String name) {
        if (this.status != ComponentStatus.INSTANTIATED) {
            this.status = ComponentStatus.STOPPING;
            log.infof("Stopping server %s", (Object)name);
            this.stop();
            log.infof("Stopped server %s", (Object)name);
        }
        this.status = ComponentStatus.TERMINATED;
    }

    private void copyProvidedServerConfigurationFile() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File configFile = new File(this.configuration.configurationFile());
        if (configFile.isAbsolute()) {
            Path source = Paths.get(configFile.getParentFile().getAbsolutePath(), new String[0]);
            Exceptions.unchecked(() -> Util.recursiveDirectoryCopy((Path)source, (Path)this.confDir.toPath()));
            return;
        }
        URL resourceUrl = classLoader.getResource(this.configuration.configurationFile());
        if (resourceUrl == null) {
            throw new RuntimeException("Cannot find test configuration file: " + this.configuration.configurationFile());
        }
        Exceptions.unchecked(() -> {
            if (resourceUrl.getProtocol().equals("jar")) {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "true");
                String[] parts = resourceUrl.toString().split("!");
                URI jarUri = new URI(parts[0]);
                try (FileSystem fs = FileSystems.newFileSystem(jarUri, env);){
                    String configJarPath = new File(parts[1]).getParentFile().toString();
                    Path source = fs.getPath(configJarPath, new String[0]);
                    Util.recursiveDirectoryCopy((Path)source, (Path)this.confDir.toPath());
                }
            } else {
                Path source = Paths.get(resourceUrl.toURI().resolve("."));
                Util.recursiveDirectoryCopy((Path)source, (Path)this.confDir.toPath());
            }
        });
    }

    protected static File createServerHierarchy(File baseDir) {
        return AbstractInfinispanServerDriver.createServerHierarchy(baseDir, null, null);
    }

    protected static File createServerHierarchy(File baseDir, String name) {
        return AbstractInfinispanServerDriver.createServerHierarchy(baseDir, name, null);
    }

    protected static File createServerHierarchy(File baseDir, String name, BiConsumer<File, String> consumer) {
        File rootDir = name == null ? baseDir : new File(baseDir, name);
        for (String dir : Arrays.asList("data", "log", "lib")) {
            File d = new File(rootDir, dir);
            if (!d.exists() && !d.mkdirs()) {
                throw new IllegalStateException("Unable to create directory " + d);
            }
            if (consumer == null) continue;
            consumer.accept(d, dir);
        }
        return rootDir;
    }

    protected void createUserFile(String realm) {
        UserTool userTool = new UserTool(this.rootDir.getAbsolutePath());
        for (AuthorizationPermission authorizationPermission : AuthorizationPermission.values()) {
            String name = authorizationPermission.name().toLowerCase();
            userTool.createUser(name + "_user", name, realm, UserTool.Encryption.DEFAULT, Collections.singletonList(name), null);
        }
        for (TestUser testUser : TestUser.values()) {
            if (testUser == TestUser.ANONYMOUS) continue;
            userTool.createUser(testUser.getUser(), testUser.getPassword(), realm, UserTool.Encryption.DEFAULT, testUser.getRoles(), null);
        }
    }

    protected void copyArtifactsToUserLibDir(File libDir) {
        String[] artifacts;
        String propertyArtifacts = this.configuration.properties().getProperty("org.infinispan.test.server.extension.libs");
        String[] stringArray = artifacts = propertyArtifacts != null ? propertyArtifacts.replaceAll("\\s+", "").split(",") : this.configuration.mavenArtifacts();
        if (artifacts != null && artifacts.length > 0) {
            MavenResolvedArtifact[] archives;
            MavenResolvedArtifact[] mavenResolvedArtifactArray = archives = (MavenResolvedArtifact[])((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(artifacts)).withoutTransitivity()).asResolvedArtifact();
            int n = mavenResolvedArtifactArray.length;
            for (int i = 0; i < n; ++i) {
                MavenResolvedArtifact archive = mavenResolvedArtifactArray[i];
                Exceptions.unchecked(() -> {
                    Path source = archive.asFile().toPath();
                    Files.copy(source, libDir.toPath().resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
                });
            }
        }
        if (this.configuration.archives() != null) {
            for (JavaArchive artifact : this.configuration.archives()) {
                File jar = libDir.toPath().resolve(artifact.getName()).toFile();
                jar.setWritable(true, false);
                ((ZipExporter)artifact.as(ZipExporter.class)).exportTo(jar, true);
            }
        }
    }

    @Override
    public File getCertificateFile(String name) {
        return new File(this.confDir, name + ".pfx");
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public File getConfDir() {
        return this.confDir;
    }

    protected void createKeyStores() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey signingKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            X500Principal CA_DN = AbstractInfinispanServerDriver.dn("CA");
            KeyStore trustStore = KeyStore.getInstance(KEYSTORE_TYPE);
            trustStore.load(null);
            SelfSignedX509CertificateAndSigningKey ca = this.createSelfSignedCertificate(CA_DN, true, "ca");
            trustStore.setCertificateEntry("ca", ca.getSelfSignedCertificate());
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "server", trustStore);
            for (TestUser user : TestUser.values()) {
                if (user == TestUser.ANONYMOUS) continue;
                this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, user.getUser(), trustStore);
            }
            this.createSignedCertificate(signingKey, publicKey, ca, CA_DN, "supervisor", trustStore);
            try (FileOutputStream os = new FileOutputStream(this.getCertificateFile("trust"));){
                trustStore.store(os, KEY_PASSWORD.toCharArray());
            }
            this.createSelfSignedCertificate(CA_DN, true, "untrusted");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static X500Principal dn(String cn) {
        return new X500Principal(String.format(BASE_DN, cn));
    }

    protected SelfSignedX509CertificateAndSigningKey createSelfSignedCertificate(X500Principal dn, boolean isCA, String name) {
        SelfSignedX509CertificateAndSigningKey.Builder certificateBuilder = SelfSignedX509CertificateAndSigningKey.builder().setDn(dn).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setKeyAlgorithmName(KEY_ALGORITHM);
        if (isCA) {
            certificateBuilder.addExtension(false, "BasicConstraints", "CA:true,pathlen:2147483647");
        }
        SelfSignedX509CertificateAndSigningKey certificate = certificateBuilder.build();
        X509Certificate issuerCertificate = certificate.getSelfSignedCertificate();
        AbstractInfinispanServerDriver.writeKeyStore(this.getCertificateFile(name), ks -> {
            try {
                ks.setCertificateEntry(name, issuerCertificate);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        return certificate;
    }

    protected void createSignedCertificate(PrivateKey signingKey, PublicKey publicKey, SelfSignedX509CertificateAndSigningKey ca, X500Principal issuerDN, String name, KeyStore trustStore) throws CertificateException {
        X509Certificate caCertificate = ca.getSelfSignedCertificate();
        X509Certificate certificate = new X509CertificateBuilder().setIssuerDn(issuerDN).setSubjectDn(AbstractInfinispanServerDriver.dn(name)).setSignatureAlgorithmName(KEY_SIGNATURE_ALGORITHM).setSigningKey(ca.getSigningKey()).setPublicKey(publicKey).setSerialNumber(BigInteger.valueOf(this.certSerial.getAndIncrement())).addExtension((X509CertificateExtension)new BasicConstraintsExtension(false, false, -1)).build();
        try {
            trustStore.setCertificateEntry(name, certificate);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        AbstractInfinispanServerDriver.writeKeyStore(this.getCertificateFile(name), ks -> {
            try {
                ks.setCertificateEntry("ca", caCertificate);
                ks.setKeyEntry(name, signingKey, KEY_PASSWORD.toCharArray(), new X509Certificate[]{certificate, caCertificate});
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void writeKeyStore(File file, Consumer<KeyStore> consumer) {
        try (FileOutputStream os = new FileOutputStream(file);){
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            keyStore.load(null);
            consumer.accept(keyStore);
            keyStore.store(os, KEY_PASSWORD.toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void applyKeyStore(ConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray());
    }

    @Override
    public void applyKeyStore(RestClientConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().keyStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).keyStorePassword(KEY_PASSWORD.toCharArray()).keyStoreType(KEYSTORE_TYPE);
    }

    @Override
    public void applyTrustStore(ConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray());
    }

    @Override
    public void applyTrustStore(RestClientConfigurationBuilder builder, String certificateName) {
        builder.security().ssl().trustStoreFileName(this.getCertificateFile(certificateName).getAbsolutePath()).trustStorePassword(KEY_PASSWORD.toCharArray()).trustStoreType(KEYSTORE_TYPE);
    }

    @Override
    public void pause(int server) {
    }

    @Override
    public RemoteCacheManager createRemoteCacheManager(ConfigurationBuilder builder) {
        return new RemoteCacheManager(builder.build());
    }
}

