/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.Closeable;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanGenericContainer;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerRunMode;
import org.testcontainers.DockerClientFactory;

public class TestServer {
    protected InfinispanServerDriver serverDriver;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();
    protected InfinispanServerTestConfiguration configuration;

    public TestServer(InfinispanServerTestConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isDriverInitialized() {
        return this.serverDriver != null;
    }

    public InfinispanServerDriver getDriver() {
        if (this.serverDriver == null) {
            throw new IllegalStateException("ServerDriver is null. Server driver not initialized");
        }
        return this.serverDriver;
    }

    public RemoteCacheManager newHotRodClient() {
        return this.newHotRodClient(new ConfigurationBuilder());
    }

    public RemoteCacheManager newHotRodClient(ConfigurationBuilder builder) {
        if (this.getDriver().getConfiguration().runMode() == ServerRunMode.CONTAINER) {
            ContainerInfinispanServerDriver containerDriver = (ContainerInfinispanServerDriver)this.serverDriver;
            for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                InfinispanGenericContainer container = containerDriver.getContainer(0);
                String hostIpAddress = DockerClientFactory.instance().dockerHostIpAddress();
                builder.addServer().host(hostIpAddress).port(container.getMappedPort(11222));
            }
        } else {
            for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
                InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, 11222);
                builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
            }
        }
        return this.getDriver().createRemoteCacheManager(builder);
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder) {
        for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress serverAddress = this.getDriver().getServerSocket(i, 11222);
            builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        }
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    CloseableMemcachedClient newMemcachedClient() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < this.getDriver().getConfiguration().numServers(); ++i) {
            InetSocketAddress unresolved = this.getDriver().getServerSocket(i, 11221);
            addresses.add(new InetSocketAddress(unresolved.getHostName(), unresolved.getPort()));
        }
        MemcachedClient memcachedClient = (MemcachedClient)Exceptions.unchecked(() -> new MemcachedClient(addresses));
        return new CloseableMemcachedClient(memcachedClient);
    }

    public void beforeListeners() {
        this.configuration.listeners().forEach(l -> l.before(this.serverDriver));
    }

    public void afterListeners() {
        this.configuration.listeners().forEach(l -> l.after(this.serverDriver));
    }

    public boolean isContainerRunWithDefaultServerConfig() {
        return this.configuration.isDefaultFile() && this.configuration.runMode() == ServerRunMode.CONTAINER;
    }

    public RestClient newRestClient(RestClientConfigurationBuilder builder, int n) {
        InetSocketAddress serverAddress = this.getDriver().getServerSocket(n, 11222);
        builder.addServer().host(serverAddress.getHostName()).port(serverAddress.getPort());
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    public void add(Consumer<File> enhancer) {
        this.configurationEnhancers.add(enhancer);
    }

    public void initServerDriver() {
        this.serverDriver = this.configuration.runMode().newDriver(this.configuration);
    }

    public void enhanceConfiguration() {
        this.configurationEnhancers.forEach(c -> c.accept(this.serverDriver.getConfDir()));
    }

    public boolean hasCrossSiteEnabled() {
        return this.configuration.site() != null;
    }

    public static class CloseableMemcachedClient
    implements Closeable {
        final MemcachedClient client;

        public CloseableMemcachedClient(MemcachedClient client) {
            this.client = client;
        }

        public MemcachedClient getClient() {
            return this.client;
        }

        @Override
        public void close() {
            this.client.shutdown();
        }
    }
}

