/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestEntity;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.test.api.BaseTestClientDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.core.TestServer;

public class RestTestClientDriver
extends BaseTestClientDriver<RestTestClientDriver> {
    public static final int TIMEOUT = 10;
    private RestClientConfigurationBuilder clientConfiguration = new RestClientConfigurationBuilder();
    private TestServer testServer;
    private TestClient testClient;

    public RestTestClientDriver(TestServer testServer, TestClient testClient) {
        this.testServer = testServer;
        this.testClient = testClient;
    }

    public RestTestClientDriver withClientConfiguration(RestClientConfigurationBuilder clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        return this;
    }

    public RestClient get() {
        return this.testClient.registerResource(this.testServer.newRestClient(this.clientConfiguration));
    }

    public RestClient get(int n) {
        return this.testClient.registerResource(this.testServer.newRestClient(this.clientConfiguration, n));
    }

    public RestClient create() {
        CompletionStage future;
        RestClient restClient = this.get();
        String name = this.testClient.getMethodName(this.qualifier);
        if (this.serverConfiguration != null) {
            RestEntity configEntity = RestEntity.create((MediaType)MediaType.APPLICATION_XML, (String)this.serverConfiguration.toXMLString(name));
            future = restClient.cache(name).createWithConfiguration(configEntity, this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
        } else {
            future = this.mode != null ? restClient.cache(name).createWithTemplate("org.infinispan." + this.mode.name(), this.flags.toArray(new CacheContainerAdmin.AdminFlag[0])) : restClient.cache(name).createWithTemplate("org.infinispan." + CacheMode.DIST_SYNC.name(), this.flags.toArray(new CacheContainerAdmin.AdminFlag[0]));
        }
        RestResponse response = (RestResponse)Exceptions.unchecked(() -> (RestResponse)future.toCompletableFuture().get(10L, TimeUnit.SECONDS));
        if (response.getStatus() != 200) {
            response.close();
            throw new RuntimeException("Could not obtain rest client = " + response.getStatus());
        }
        return restClient;
    }

    public RestTestClientDriver self() {
        return this;
    }
}

