/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.state;

import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatcher;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ssl.SslHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.globalstate.ScopeFilter;
import org.infinispan.globalstate.ScopedState;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.Server;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.server.core.ServerStateManager;
import org.infinispan.server.core.transport.CompositeChannelMatcher;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.core.transport.IpFilterRuleChannelMatcher;
import org.infinispan.server.core.transport.IpSubnetFilterRule;
import org.infinispan.server.core.transport.Transport;

public final class ServerStateManagerImpl
implements ServerStateManager {
    private static final String CONNECTOR_STATE_SCOPE = "connector-state";
    private static final String CONNECTOR_IPFILTER_SCOPE = "connector-ipfilter";
    private static final ScopedState IGNORED_CACHES_KEY = new ScopedState("ignored-caches", "ignored-caches");
    private final EmbeddedCacheManager cacheManager;
    private final Server server;
    private final IgnoredCaches ignored = new IgnoredCaches();
    private volatile Cache<ScopedState, Object> cache;
    private volatile boolean hasIgnores;

    public ServerStateManagerImpl(Server server, EmbeddedCacheManager cacheManager) {
        this.server = server;
        this.cacheManager = cacheManager;
    }

    public void start() {
        GlobalConfigurationManager gcm = (GlobalConfigurationManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)this.cacheManager).getComponent(GlobalConfigurationManager.class);
        this.cache = gcm.getStateCache();
        this.updateLocalIgnoredCaches((IgnoredCaches)this.cache.get((Object)IGNORED_CACHES_KEY));
        this.cache.addListener((Object)new IgnoredCachesListener(this), (CacheEventFilter)new ScopeFilter(IGNORED_CACHES_KEY.getScope()), null);
        this.cache.addListener((Object)new ConnectorStateListener(this), (CacheEventFilter)new ScopeFilter(CONNECTOR_STATE_SCOPE), null);
        this.cache.addListener((Object)new ConnectorIpFilterListener(this), (CacheEventFilter)new ScopeFilter(CONNECTOR_IPFILTER_SCOPE), null);
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> unignoreCache(String cacheName) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        ServerStateManagerImpl serverStateManagerImpl = this;
        synchronized (serverStateManagerImpl) {
            this.ignored.caches.remove(cacheName);
            this.hasIgnores = !this.ignored.caches.isEmpty();
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> ignoreCache(String cacheName) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        ServerStateManagerImpl serverStateManagerImpl = this;
        synchronized (serverStateManagerImpl) {
            this.ignored.caches.add(cacheName);
            this.hasIgnores = true;
            return this.cache.putAsync((Object)IGNORED_CACHES_KEY, (Object)this.ignored).thenApply(r -> null);
        }
    }

    public Set<String> getIgnoredCaches() {
        return Collections.unmodifiableSet(this.ignored.caches);
    }

    public boolean isCacheIgnored(String cacheName) {
        return this.hasIgnores && this.ignored.caches.contains(cacheName);
    }

    public CompletableFuture<Boolean> connectorStart(String name) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        return this.cache.removeAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name), (Object)true).thenApply(v -> null);
    }

    public CompletableFuture<Void> connectorStop(String name) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name), (Object)true).thenApply(v -> null);
    }

    public CompletableFuture<Boolean> connectorStatus(String name) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        return this.cache.containsKeyAsync((Object)new ScopedState(CONNECTOR_STATE_SCOPE, name)).thenApply(v -> v == false);
    }

    public CompletableFuture<Void> setConnectorIpFilterRule(String name, Collection<IpSubnetFilterRule> filterRule) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        IpFilterRules ipFilterRules = new IpFilterRules();
        filterRule.forEach(r -> ipFilterRules.rules.add(new IpFilterRule((IpSubnetFilterRule)r)));
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_IPFILTER_SCOPE, name), (Object)ipFilterRules).thenApply(v -> null);
    }

    public CompletableFuture<Void> clearConnectorIpFilterRules(String name) {
        SecurityActions.checkPermission((EmbeddedCacheManager)this.cacheManager, (AuthorizationPermission)AuthorizationPermission.ADMIN);
        return this.cache.putAsync((Object)new ScopedState(CONNECTOR_IPFILTER_SCOPE, name), (Object)new IpFilterRules()).thenApply(v -> null);
    }

    public CompletableFuture<Json> listConnections() {
        Json r = Json.array();
        for (Map.Entry<String, ProtocolServer> ps : this.server.getProtocolServers().entrySet()) {
            Transport transport = ps.getValue().getTransport();
            if (transport == null) continue;
            ChannelGroup channels = transport.getAcceptedChannels();
            channels.forEach(ch -> {
                ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ch);
                Json o = Json.object();
                o.set("id", (Object)metadata.id());
                o.set("server-node-name", (Object)((Comparable)((Object)Objects.requireNonNullElse(this.cacheManager.getAddress(), "local"))).toString());
                o.set("name", (Object)metadata.clientName());
                o.set("created", (Object)metadata.created());
                o.set("principal", (Object)Security.getSubjectUserPrincipalName((Subject)metadata.subject()));
                o.set("local-address", (Object)metadata.localAddress().toString());
                o.set("remote-address", (Object)metadata.remoteAddress().toString());
                o.set("protocol-version", (Object)metadata.protocolVersion());
                o.set("client-library", (Object)metadata.clientLibraryName());
                o.set("client-version", (Object)metadata.clientLibraryVersion());
                SslHandler ssl = (SslHandler)ch.pipeline().get(SslHandler.class);
                if (ssl != null) {
                    o.set("ssl-application-protocol", (Object)ssl.applicationProtocol());
                    o.set("ssl-cipher-suite", (Object)ssl.engine().getSession().getCipherSuite());
                    o.set("ssl-protocol", (Object)ssl.engine().getSession().getProtocol());
                }
                r.add(o);
            });
        }
        return CompletableFuture.completedFuture(r);
    }

    public Json clientsReport() {
        Json result = Json.object();
        for (ProtocolServer protocolServer : this.server.getProtocolServers().values()) {
            ChannelGroup channels;
            Transport transport = protocolServer.getTransport();
            if (transport == null || (channels = transport.getAcceptedChannels()).isEmpty()) continue;
            HashSet<String> clientNames = new HashSet<String>();
            HashSet<String> protocolVersions = new HashSet<String>();
            HashSet<String> clientLibraryNames = new HashSet<String>();
            HashSet<String> clientLibraryVersions = new HashSet<String>();
            for (Channel channel : channels) {
                String clientLibraryVersion;
                String clientLibraryName;
                String protocolVersion;
                ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)channel);
                String clientName = metadata.clientName();
                if (clientName != null) {
                    clientNames.add(clientName);
                }
                if ((protocolVersion = metadata.protocolVersion()) != null) {
                    protocolVersions.add(protocolVersion);
                }
                if ((clientLibraryName = metadata.clientLibraryName()) != null) {
                    clientLibraryNames.add(clientLibraryName);
                }
                if ((clientLibraryVersion = metadata.clientLibraryVersion()) == null) continue;
                clientLibraryVersions.add(clientLibraryVersion);
            }
            Json protocolServerReport = Json.object();
            if (!clientNames.isEmpty()) {
                protocolServerReport.set("client-names", Json.make(clientNames));
            }
            if (!protocolVersions.isEmpty()) {
                protocolServerReport.set("protocol-versions", Json.make(protocolVersions));
            }
            if (!clientLibraryNames.isEmpty()) {
                protocolServerReport.set("client-library-names", Json.make(clientLibraryNames));
            }
            if (!clientLibraryVersions.isEmpty()) {
                protocolServerReport.set("client-library-versions", Json.make(clientLibraryVersions));
            }
            result.set(protocolServer.getName(), protocolServerReport);
        }
        return result;
    }

    public ServerManagement managedServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalIgnoredCaches(IgnoredCaches ignored) {
        if (ignored != null) {
            ServerStateManagerImpl serverStateManagerImpl = this;
            synchronized (serverStateManagerImpl) {
                this.ignored.caches.clear();
                this.ignored.caches.addAll(ignored.caches);
                this.hasIgnores = !this.ignored.caches.isEmpty();
            }
        }
    }

    private CompletionStage<Void> updateIpFilters(String connector, Collection<IpFilterRule> rules) {
        ProtocolServer protocolServer = this.server.getProtocolServers().get(connector);
        if (rules.isEmpty()) {
            protocolServer.getConfiguration().ipFilter().rules(Collections.emptyList());
            Server.log.connectorIpFilterCleared(connector);
            return CompletableFutures.completedNull();
        }
        ArrayList<IpSubnetFilterRule> localRules = new ArrayList<IpSubnetFilterRule>(rules.size());
        for (IpFilterRule rule : rules) {
            localRules.add(new IpSubnetFilterRule(rule.cidr, IpFilterRuleType.valueOf((String)rule.type)));
        }
        protocolServer.getConfiguration().ipFilter().rules(localRules);
        Transport transport = this.getTransport(protocolServer);
        CompositeChannelMatcher matcher = new CompositeChannelMatcher(new ChannelMatcher[]{protocolServer.getChannelMatcher(), new IpFilterRuleChannelMatcher(localRules)});
        return transport.closeChannels((ChannelMatcher)matcher).thenApply(v -> {
            Server.log.connectorIpFilterSet(connector, localRules);
            return v;
        });
    }

    private Transport getTransport(ProtocolServer protocolServer) {
        Transport transport = protocolServer.getTransport();
        if (transport == null) {
            transport = protocolServer.getEnclosingProtocolServer().getTransport();
        }
        return transport;
    }

    @ProtoTypeId(value=5400)
    public static final class IgnoredCaches {
        @ProtoField(number=1, collectionImplementation=HashSet.class)
        final Set<String> caches;

        IgnoredCaches() {
            this(ConcurrentHashMap.newKeySet());
        }

        @ProtoFactory
        IgnoredCaches(Set<String> caches) {
            this.caches = ConcurrentHashMap.newKeySet(caches.size());
            this.caches.addAll(caches);
        }

        public String toString() {
            return "IgnoredCaches" + String.valueOf(this.caches);
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class IgnoredCachesListener {
        final /* synthetic */ ServerStateManagerImpl this$0;

        private IgnoredCachesListener(ServerStateManagerImpl serverStateManagerImpl) {
            ServerStateManagerImpl serverStateManagerImpl2 = serverStateManagerImpl;
            Objects.requireNonNull(serverStateManagerImpl2);
            this.this$0 = serverStateManagerImpl2;
        }

        @CacheEntryCreated
        public void created(CacheEntryCreatedEvent<ScopedState, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                this.this$0.updateLocalIgnoredCaches((IgnoredCaches)e.getValue());
            }
        }

        @CacheEntryModified
        public void modified(CacheEntryModifiedEvent<ScopedState, IgnoredCaches> e) {
            if (!e.isOriginLocal()) {
                this.this$0.updateLocalIgnoredCaches((IgnoredCaches)e.getValue());
            }
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class ConnectorStateListener {
        final /* synthetic */ ServerStateManagerImpl this$0;

        private ConnectorStateListener(ServerStateManagerImpl serverStateManagerImpl) {
            ServerStateManagerImpl serverStateManagerImpl2 = serverStateManagerImpl;
            Objects.requireNonNull(serverStateManagerImpl2);
            this.this$0 = serverStateManagerImpl2;
        }

        @CacheEntryCreated
        public CompletionStage<Void> created(CacheEntryCreatedEvent<ScopedState, Boolean> e) {
            String connector = ((ScopedState)e.getKey()).getName();
            ProtocolServer protocolServer = this.this$0.server.getProtocolServers().get(connector);
            protocolServer.getConfiguration().disable();
            Transport transport = this.this$0.getTransport(protocolServer);
            return transport.closeChannels(protocolServer.getChannelMatcher()).thenApply(v -> {
                Server.log.connectorStopped(connector);
                return v;
            });
        }

        @CacheEntryRemoved
        public void removed(CacheEntryRemovedEvent<ScopedState, Boolean> e) {
            String connector = ((ScopedState)e.getKey()).getName();
            this.this$0.server.getProtocolServers().get(connector).getConfiguration().enable();
            Server.log.connectorStarted(connector);
        }
    }

    @Listener(observation=Listener.Observation.POST, includeCurrentState=true, clustered=true)
    private final class ConnectorIpFilterListener {
        final /* synthetic */ ServerStateManagerImpl this$0;

        private ConnectorIpFilterListener(ServerStateManagerImpl serverStateManagerImpl) {
            ServerStateManagerImpl serverStateManagerImpl2 = serverStateManagerImpl;
            Objects.requireNonNull(serverStateManagerImpl2);
            this.this$0 = serverStateManagerImpl2;
        }

        @CacheEntryCreated
        @CacheEntryModified
        public CompletionStage<Void> modified(CacheEntryEvent<ScopedState, IpFilterRules> e) {
            return this.this$0.updateIpFilters(((ScopedState)e.getKey()).getName(), ((IpFilterRules)e.getValue()).rules);
        }
    }

    @ProtoTypeId(value=5403)
    public static final class IpFilterRules {
        @ProtoField(number=1, collectionImplementation=LinkedHashSet.class)
        final Set<IpFilterRule> rules;

        IpFilterRules() {
            this(new LinkedHashSet<IpFilterRule>());
        }

        @ProtoFactory
        IpFilterRules(Set<IpFilterRule> rules) {
            this.rules = new LinkedHashSet<IpFilterRule>(rules.size());
            this.rules.addAll(rules);
        }
    }

    @ProtoTypeId(value=5404)
    public static final class IpFilterRule {
        @ProtoField(number=1)
        final String cidr;
        @ProtoField(number=2)
        final String type;

        @ProtoFactory
        IpFilterRule(String cidr, String type) {
            this.cidr = cidr;
            this.type = type;
        }

        IpFilterRule(IpSubnetFilterRule filterRule) {
            this(filterRule.cidr(), filterRule.ruleType().name());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IpFilterRule that = (IpFilterRule)o;
            return this.cidr.equals(that.cidr) && this.type.equals(that.type);
        }

        public int hashCode() {
            return Objects.hash(this.cidr, this.type);
        }
    }
}

