/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.security.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.infinispan.server.security.realm.CachingSecurityRealm;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public class CachingModifiableSecurityRealm
extends CachingSecurityRealm
implements ModifiableSecurityRealm {
    public CachingModifiableSecurityRealm(CacheableSecurityRealm realm, RealmIdentityCache cache) {
        super(realm, cache);
    }

    public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) throws RealmUnavailableException {
        return this.wrap(this.getModifiableSecurityRealm().getRealmIdentityForUpdate(principal));
    }

    public ModifiableRealmIdentityIterator getRealmIdentityIterator() throws RealmUnavailableException {
        final ModifiableRealmIdentityIterator iterator = this.getModifiableSecurityRealm().getRealmIdentityIterator();
        return new ModifiableRealmIdentityIterator(){
            final /* synthetic */ CachingModifiableSecurityRealm this$0;
            {
                CachingModifiableSecurityRealm cachingModifiableSecurityRealm = this$0;
                Objects.requireNonNull(cachingModifiableSecurityRealm);
                this.this$0 = cachingModifiableSecurityRealm;
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public ModifiableRealmIdentity next() {
                return this.this$0.wrap((ModifiableRealmIdentity)iterator.next());
            }
        };
    }

    private ModifiableRealmIdentity wrap(final ModifiableRealmIdentity modifiable) {
        return new ModifiableRealmIdentity(){
            final /* synthetic */ CachingModifiableSecurityRealm this$0;
            {
                CachingModifiableSecurityRealm cachingModifiableSecurityRealm = this$0;
                Objects.requireNonNull(cachingModifiableSecurityRealm);
                this.this$0 = cachingModifiableSecurityRealm;
            }

            public void delete() throws RealmUnavailableException {
                this.executeAndInvalidate((ExceptionConsumer<ModifiableRealmIdentity, RealmUnavailableException>)((ExceptionConsumer)modifiable -> modifiable.delete()));
            }

            public void create() throws RealmUnavailableException {
                modifiable.create();
            }

            public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
                this.executeAndInvalidate((ExceptionConsumer<ModifiableRealmIdentity, RealmUnavailableException>)((ExceptionConsumer)modifiable -> modifiable.setCredentials(credentials)));
            }

            public void setAttributes(Attributes attributes) throws RealmUnavailableException {
                this.executeAndInvalidate((ExceptionConsumer<ModifiableRealmIdentity, RealmUnavailableException>)((ExceptionConsumer)modifiable -> modifiable.setAttributes(attributes)));
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return modifiable.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return (C)modifiable.getCredential(credentialType);
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return modifiable.getEvidenceVerifySupport(evidenceType, algorithmName);
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return modifiable.verifyEvidence(evidence);
            }

            public boolean exists() throws RealmUnavailableException {
                return modifiable.exists();
            }

            public void updateCredential(Credential credential) throws RealmUnavailableException {
                this.executeAndInvalidate((ExceptionConsumer<ModifiableRealmIdentity, RealmUnavailableException>)((ExceptionConsumer)modifiable -> modifiable.updateCredential(credential)));
            }

            public Principal getRealmIdentityPrincipal() {
                return modifiable.getRealmIdentityPrincipal();
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
                return (C)modifiable.getCredential(credentialType, algorithmName);
            }

            public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return (C)modifiable.getCredential(credentialType, algorithmName, parameterSpec);
            }

            public <C extends Credential, R> R applyToCredential(Class<C> credentialType, Function<C, R> function) throws RealmUnavailableException {
                return (R)modifiable.applyToCredential(credentialType, function);
            }

            public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, Function<C, R> function) throws RealmUnavailableException {
                return (R)modifiable.applyToCredential(credentialType, algorithmName, function);
            }

            public <C extends Credential, R> R applyToCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec, Function<C, R> function) throws RealmUnavailableException {
                return (R)modifiable.applyToCredential(credentialType, algorithmName, parameterSpec, function);
            }

            public void dispose() {
                modifiable.dispose();
            }

            public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
                return modifiable.getAuthorizationIdentity();
            }

            public Attributes getAttributes() throws RealmUnavailableException {
                return modifiable.getAttributes();
            }

            private void executeAndInvalidate(ExceptionConsumer<ModifiableRealmIdentity, RealmUnavailableException> operation) throws RealmUnavailableException {
                try {
                    operation.accept((Object)modifiable);
                }
                catch (RealmUnavailableException rue) {
                    throw rue;
                }
                finally {
                    this.this$0.removeFromCache(modifiable.getRealmIdentityPrincipal());
                }
            }
        };
    }

    private ModifiableSecurityRealm getModifiableSecurityRealm() {
        return (ModifiableSecurityRealm)this.getCacheableRealm();
    }
}

