/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.io.IOException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.NetworkAddress;
import org.infinispan.server.configuration.AddressConfigurationBuilder;
import org.infinispan.server.configuration.AddressType;
import org.infinispan.server.configuration.InterfaceConfiguration;

public class InterfaceConfigurationBuilder
implements Builder<InterfaceConfiguration> {
    private final AttributeSet attributes;
    private final AddressConfigurationBuilder address = new AddressConfigurationBuilder();
    private NetworkAddress networkAddress;

    InterfaceConfigurationBuilder(String name) {
        this.attributes = InterfaceConfiguration.attributeDefinitionSet();
        this.attributes.attribute(InterfaceConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public InterfaceConfigurationBuilder address(AddressType addressType, String addressValue) throws IOException {
        this.address.type(addressType, addressValue);
        this.networkAddress = this.createNetworkAddress();
        return this;
    }

    NetworkAddress networkAddress() {
        return this.networkAddress;
    }

    public String name() {
        return (String)this.attributes.attribute(InterfaceConfiguration.NAME).get();
    }

    private NetworkAddress createNetworkAddress() throws IOException {
        String interfaceName = this.name();
        AddressType addressType = this.address.addressType();
        String addressValue = this.address.value();
        return switch (addressType) {
            default -> throw new MatchException(null, null);
            case AddressType.ANY_ADDRESS -> NetworkAddress.anyAddress((String)interfaceName);
            case AddressType.INET_ADDRESS -> NetworkAddress.fromString((String)interfaceName, (String)addressValue);
            case AddressType.LINK_LOCAL -> NetworkAddress.linkLocalAddress((String)interfaceName);
            case AddressType.GLOBAL -> NetworkAddress.globalAddress((String)interfaceName);
            case AddressType.LOOPBACK -> NetworkAddress.loopback((String)interfaceName);
            case AddressType.NON_LOOPBACK -> NetworkAddress.nonLoopback((String)interfaceName);
            case AddressType.SITE_LOCAL -> NetworkAddress.siteLocal((String)interfaceName);
            case AddressType.MATCH_INTERFACE -> NetworkAddress.matchInterface((String)interfaceName, (String)addressValue);
            case AddressType.MATCH_ADDRESS -> NetworkAddress.matchAddress((String)interfaceName, (String)addressValue);
            case AddressType.MATCH_HOST -> NetworkAddress.matchHost((String)interfaceName, (String)addressValue);
        };
    }

    public InterfaceConfiguration create() {
        return new InterfaceConfiguration(this.attributes.protect(), this.address.create(), this.networkAddress);
    }

    public InterfaceConfigurationBuilder read(InterfaceConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.address.read(template.addressConfiguration(), combine);
        return this;
    }
}

