/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.logging;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.naming.NamingException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.OS;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.IpSubnetFilterRule;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;
import org.wildfly.security.auth.server.RealmUnavailableException;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=80000, max=81000)
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server %s starting", id=80000)
    public void serverStarting(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server %s started in %dms", id=80001)
    public void serverStarted(String var1, String var2, long var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server stopping", id=80002)
    public void serverStopping(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="%s Server stopped", id=80003)
    public void serverStopped(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector %s (%s) listening on %s:%d", id=80004)
    public void protocolStarted(String var1, String var2, String var3, int var4);

    @Message(value="Cannot instantiate protocol server configuration '%s'", id=80008)
    public CacheConfigurationException cannotInstantiateProtocolServerConfigurationBuilder(Class<?> var1, @Cause Exception var2);

    @Message(value="Unknown interface '%s'", id=80009)
    public CacheConfigurationException unknownInterface(String var1);

    @Message(value="Unknown socket binding '%s'", id=80010)
    public CacheConfigurationException unknownSocketBinding(String var1);

    @Message(value="Unknown security domain '%s'", id=80014)
    public CacheConfigurationException unknownSecurityDomain(String var1);

    @Message(value="Unable to load realm property files", id=80015)
    public CacheConfigurationException unableToLoadRealmPropertyFiles(@Cause IOException var1);

    @Message(value="No default key manager available", id=80016)
    public NoSuchAlgorithmException noDefaultKeyManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server configuration: %s", id=80017)
    public void serverConfiguration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector %s", id=80018)
    public void protocolStarted(ProtocolServer<?> var1);

    @Message(value="Authentication cannot be configured without a security realm", id=80021)
    public CacheConfigurationException authenticationWithoutSecurityRealm();

    @Message(value="Cannot configure protocol encryption under a single port endpoint. Use a dedicated socket binding.", id=80022)
    public CacheConfigurationException cannotConfigureProtocolEncryptionUnderSinglePort();

    @Message(value="Cannot configure a protocol with the same socket binding used by the endpoint. Use a dedicated socket binding.", id=80023)
    public CacheConfigurationException protocolCannotUseSameSocketBindingAsEndpoint();

    @Message(value="Invalid URL: '%s'", id=80024)
    public CacheConfigurationException invalidUrl(String var1);

    @Message(value="Cannot have multiple connectors of the same type: found [%s]", id=80025)
    public CacheConfigurationException multipleEndpointsSameTypeFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Extension factory '%s' is lacking a @NamedFactory annotation", id=80026)
    public void unnamedFactoryClass(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Loaded extension '%s'", id=80027)
    public void loadedExtension(String var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(value="%s Server failed to start", id=80028)
    public void serverFailedToStart(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cluster shutdown", id=80029)
    public void clusterShutdown();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Clustered task error", id=80030)
    public void clusteredTaskError(@Cause Throwable var1);

    @Message(value="Unknown server identity '%s'", id=80031)
    public IllegalArgumentException unknownServerIdentity(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Logging configuration: %s", id=80032)
    public void loggingConfiguration(String var1);

    @Message(value="Cannot find a network address which matches the supplied configuration", id=80033)
    public CacheConfigurationException invalidNetworkConfiguration();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server '%s' listening on %s://%s:%d", id=80034)
    public void endpointUrl(Object var1, String var2, String var3, int var4);

    @Message(value="Unknown appender `%s`", id=80035)
    public IllegalArgumentException unknownAppender(String var1);

    @Message(value="Invalid level `%s`", id=80036)
    public IllegalArgumentException invalidLevel(String var1);

    @Message(value="The name '%s' is already bound", id=80037)
    public NamingException nameAlreadyBound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Created datasource '%s' bound to JNDI '%s'", id=80038)
    public void dataSourceCreated(String var1, String var2);

    @Message(value="No realm name found in users property file - non-plain-text users file must contain \"#$REALM_NAME=RealmName$\" line", id=80040)
    public RealmUnavailableException noRealmFoundInProperties();

    @Message(value="Duplicate data source '%s'", id=80041)
    public CacheConfigurationException duplicateDataSource(String var1);

    @Message(value="Duplicate JNDI name '%s'", id=80042)
    public CacheConfigurationException duplicateJndiName(String var1);

    @Message(value="Cannot generate the server report on %s", id=80043)
    public IllegalStateException serverReportUnavailable(OS var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="HotRod lazy-retrieval has been deprecated and will be removed in a future version with no direct replacement", id=80044)
    public void warnHotRodLazyRetrievalDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Overriding existing endpoint on socket-binding '%s'", id=80045)
    public void endpointSocketBindingOverride(String var1);

    @Message(value="Unknown credential store '%s'", id=80046)
    public IllegalArgumentException unknownCredentialStore(String var1);

    @Message(value="Unknown credential '%s' in store '%s'", id=80047)
    public IllegalArgumentException unknownCredential(String var1, String var2);

    @Message(value="A credential store name is missing", id=80048)
    public IllegalArgumentException missingCredentialStoreName();

    @Message(value="A credential alias must be specified if the store doesn't contain a single alias", id=80049)
    public CacheConfigurationException unspecifiedCredentialAlias();

    @Message(value="Credential reference in element '%s' would override value specified in attribute '%s'", id=80050)
    public CacheConfigurationException cannotOverrideCredential(String var1, String var2);

    @Message(value="Element '%s' is missing a credential attribute '%s' or a credential reference", id=80051)
    public CacheConfigurationException missingCredential(String var1, String var2);

    @Message(value="The request authentication mechanism '%s' is not supported", id=80052)
    public SecurityException unsupportedMechanism(String var1);

    @Message(value="Encryption cannot be configured without a security realm", id=80053)
    public CacheConfigurationException encryptionWithoutSecurityRealm();

    @Message(value="No default trust manager available", id=80054)
    public CacheConfigurationException noDefaultTrustManager();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector '%s': IP filter set: %s", id=80055)
    public void connectorIpFilterSet(String var1, List<IpSubnetFilterRule> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector '%s': IP filter cleared", id=80056)
    public void connectorIpFilterCleared(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector '%s': stopped", id=80057)
    public void connectorStopped(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Connector '%s': started", id=80058)
    public void connectorStarted(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No script engines are available", id=80059)
    public void noScriptEngines();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="SSL Transport using realm '%s`", id=80060)
    public void sslTransport(String var1);

    @Message(value="Realm '%s' does not provide an SSL context", id=80061)
    public IllegalStateException noSSLContext(String var1);

    @Message(value="Cannot add multiple realms of type '%s' to security realm '%s'", id=80062)
    public CacheConfigurationException duplicateRealmType(String var1, String var2);

    @Message(value="Duplicate realm '%s'", id=80063)
    public CacheConfigurationException duplicateRealm(String var1);

    @Message(value="Unknown realm '%s'", id=80064)
    public CacheConfigurationException unknownRealm(String var1);

    @Message(value="Invalid keystore '%s'", id=80065)
    public KeyStoreException invalidKeyStore(String var1);

    @Message(value="KeyStore definitions without a path must specify a type.", id=80066)
    public CacheConfigurationException filelessKeyStoreRequiresType();

    @Message(value="The RESP endpoint requires a security realm which supports passwords or a trustore realm.", id=80067)
    public CacheConfigurationException respEndpointRequiresRealmWithPasswordOrTrustore();

    @Message(value="Wrong masked password format", id=80068)
    public CacheConfigurationException wrongMaskedPasswordFormat();

    @Message(value="Alias '%s' not in keystore '%s'", id=80069)
    public CacheConfigurationException aliasNotInKeystore(String var1, String var2);

    @Message(value="The cache container requires authorization, but none of the connectors enable authentication", id=80070)
    public CacheConfigurationException authorizationWithoutAuthentication();

    @Message(value="A user mapper must be configured in order to use LDAP direct verification", id=80071)
    public CacheConfigurationException ldapDirectVerificationWithoutUserMapper();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="JMX remoting enabled without a default security realm. All connections will be rejected.", id=80072)
    public void jmxNoDefaultSecurityRealm();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="JMX authentication error", id=80073)
    public void jmxAuthenticationError(@Cause Throwable var1);

    @Message(value="The Memcached endpoint text protocol requires a security realm which supports passwords.", id=80074)
    public CacheConfigurationException memcachedTextEndpointRequiresRealmWithPassword();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The '%2$s' certificate in keystore '%1$s' does not have the subjectAltName extension as recommended by RFC2818.", id=80075)
    public void serverCertificateWithoutSAN(String var1, String var2);

    @Message(value="Malformed entry in user properties file at line %d", id=80076)
    public IllegalStateException malformedUserProperties(int var1);
}

