/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.NamedFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.Server;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.tasks.ServerTaskEngine;
import org.infinispan.server.tasks.ServerTaskWrapper;
import org.infinispan.tasks.ServerTask;
import org.infinispan.tasks.spi.TaskEngine;

public class Extensions {
    private final Map<String, CacheEventFilterFactory> filterFactories = new HashMap<String, CacheEventFilterFactory>();
    private final Map<String, CacheEventConverterFactory> converterFactories = new HashMap<String, CacheEventConverterFactory>();
    private final Map<String, CacheEventFilterConverterFactory> filterConverterFactories = new HashMap<String, CacheEventFilterConverterFactory>();
    private final Map<String, KeyValueFilterConverterFactory> keyValueFilterConverterFactories = new HashMap<String, KeyValueFilterConverterFactory>();
    private final Map<String, ParamKeyValueFilterConverterFactory> paramKeyValueFilterConverterFactories = new HashMap<String, ParamKeyValueFilterConverterFactory>();
    private final Map<String, ServerTaskWrapper> serverTasks = new HashMap<String, ServerTaskWrapper>();

    public void load(ClassLoader classLoader) {
        this.loadNamedFactory(classLoader, CacheEventFilterFactory.class, this.filterFactories);
        this.loadNamedFactory(classLoader, CacheEventConverterFactory.class, this.converterFactories);
        this.loadNamedFactory(classLoader, CacheEventFilterConverterFactory.class, this.filterConverterFactories);
        this.loadNamedFactory(classLoader, KeyValueFilterConverterFactory.class, this.keyValueFilterConverterFactories);
        this.loadNamedFactory(classLoader, ParamKeyValueFilterConverterFactory.class, this.paramKeyValueFilterConverterFactories);
        this.loadService(classLoader, Driver.class);
        this.loadService(classLoader, ScriptEngineFactory.class);
        this.loadServerTasks(classLoader);
    }

    public void apply(HotRodServer server) {
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterFactories.entrySet()) {
            server.addCacheEventFilterFactory(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.converterFactories.entrySet()) {
            server.addCacheEventConverterFactory(entry.getKey(), (CacheEventConverterFactory)entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.filterConverterFactories.entrySet()) {
            server.addCacheEventFilterConverterFactory(entry.getKey(), (CacheEventFilterConverterFactory)entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.keyValueFilterConverterFactories.entrySet()) {
            server.addKeyValueFilterConverterFactory(entry.getKey(), (KeyValueFilterConverterFactory)entry.getValue());
        }
        for (Map.Entry<String, CacheEventFilterFactory> entry : this.paramKeyValueFilterConverterFactories.entrySet()) {
            server.addKeyValueFilterConverterFactory(entry.getKey(), (KeyValueFilterConverterFactory)entry.getValue());
        }
    }

    private <T> void loadNamedFactory(ClassLoader classLoader, Class<T> contract, Map<String, T> map) {
        for (Object t : ServiceFinder.load(contract, (ClassLoader[])new ClassLoader[]{classLoader})) {
            NamedFactory name = t.getClass().getAnnotation(NamedFactory.class);
            if (name != null) {
                map.put(name.name(), t);
                Server.log.loadedExtension(name.name());
                continue;
            }
            Server.log.unnamedFactoryClass(t.getClass().getName());
        }
    }

    private <T> void loadService(ClassLoader classLoader, Class<T> contract) {
        for (Object t : ServiceFinder.load(contract, (ClassLoader[])new ClassLoader[]{classLoader})) {
            Server.log.loadedExtension(t.getClass().getName());
        }
    }

    private void loadServerTasks(ClassLoader classLoader) {
        for (ServerTask t : ServiceFinder.load(ServerTask.class, (ClassLoader[])new ClassLoader[]{classLoader})) {
            this.serverTasks.put(t.getName(), new ServerTaskWrapper(t));
            Server.log.loadedExtension(t.getClass().getName());
        }
    }

    public TaskEngine getServerTaskEngine(EmbeddedCacheManager cm) {
        return new ServerTaskEngine(cm, this.serverTasks);
    }
}

