/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.infinispan.server.configuration.security.SSLEngineConfiguration;
import org.wildfly.security.ssl.CipherSuiteSelector;
import org.wildfly.security.ssl.ProtocolSelector;

public class SSLEngineConfigurationBuilder
implements Builder<SSLEngineConfiguration> {
    private final AttributeSet attributes;
    private final RealmConfigurationBuilder realmBuilder;

    SSLEngineConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
        this.attributes = SSLEngineConfiguration.attributeDefinitionSet();
    }

    public SSLEngineConfigurationBuilder enabledProtocols(String[] protocols) {
        this.attributes.attribute(SSLEngineConfiguration.ENABLED_PROTOCOLS).set((Object)protocols);
        ProtocolSelector protocolSelector = ProtocolSelector.empty();
        for (String protocol : protocols) {
            protocolSelector = protocolSelector.add(protocol);
        }
        this.realmBuilder.sslContextBuilder().setProtocolSelector(protocolSelector);
        return this;
    }

    public SSLEngineConfigurationBuilder enabledCiphersuites(String cipherSuites) {
        this.attributes.attribute(SSLEngineConfiguration.ENABLED_CIPHERSUITES).set((Object)cipherSuites);
        this.realmBuilder.sslContextBuilder().setCipherSuiteSelector(CipherSuiteSelector.fromString((String)cipherSuites));
        return this;
    }

    public void validate() {
    }

    public SSLEngineConfiguration create() {
        return new SSLEngineConfiguration(this.attributes.protect());
    }

    public SSLEngineConfigurationBuilder read(SSLEngineConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

