/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.io.File;
import java.nio.file.Path;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.server.configuration.security.FileSystemRealmConfiguration;
import org.infinispan.server.configuration.security.RealmConfigurationBuilder;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityRealm;

public class FileSystemRealmConfigurationBuilder
implements Builder<FileSystemRealmConfiguration> {
    private final AttributeSet attributes = FileSystemRealmConfiguration.attributeDefinitionSet();
    private final RealmConfigurationBuilder realmBuilder;
    private FileSystemSecurityRealm securityRealm;

    FileSystemRealmConfigurationBuilder(RealmConfigurationBuilder realmBuilder) {
        this.realmBuilder = realmBuilder;
    }

    public FileSystemRealmConfigurationBuilder name(String name) {
        this.attributes.attribute(FileSystemRealmConfiguration.NAME).set((Object)name);
        return this;
    }

    public FileSystemRealmConfigurationBuilder path(String path) {
        this.attributes.attribute(FileSystemRealmConfiguration.PATH).set((Object)path);
        return this;
    }

    public FileSystemRealmConfigurationBuilder relativeTo(String relativeTo) {
        this.attributes.attribute(FileSystemRealmConfiguration.RELATIVE_TO).set((Object)relativeTo);
        return this;
    }

    public FileSystemRealmConfigurationBuilder levels(int levels) {
        this.attributes.attribute(FileSystemRealmConfiguration.LEVELS).set((Object)levels);
        return this;
    }

    public FileSystemRealmConfigurationBuilder encoded(boolean encoded) {
        this.attributes.attribute(FileSystemRealmConfiguration.ENCODED).set((Object)encoded);
        return this;
    }

    public void validate() {
    }

    public FileSystemRealmConfiguration create() {
        return new FileSystemRealmConfiguration(this.attributes.protect(), this.securityRealm);
    }

    public FileSystemRealmConfigurationBuilder read(FileSystemRealmConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public FileSystemSecurityRealm build() {
        if (this.securityRealm == null && this.attributes.isModified()) {
            String name = (String)this.attributes.attribute(FileSystemRealmConfiguration.NAME).get();
            String path = (String)this.attributes.attribute(FileSystemRealmConfiguration.PATH).get();
            String relativeTo = (String)this.attributes.attribute(FileSystemRealmConfiguration.RELATIVE_TO).get();
            Integer levels = (Integer)this.attributes.attribute(FileSystemRealmConfiguration.LEVELS).get();
            Boolean encoded = (Boolean)this.attributes.attribute(FileSystemRealmConfiguration.ENCODED).get();
            Path filesystemPath = new File(ParseUtils.resolvePath((String)path, (String)relativeTo)).toPath();
            this.securityRealm = new FileSystemSecurityRealm(filesystemPath, NameRewriter.IDENTITY_REWRITER, levels.intValue(), encoded.booleanValue());
            this.realmBuilder.domainBuilder().addRealm(name, (SecurityRealm)this.securityRealm).build();
        }
        return this.securityRealm;
    }
}

