/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.network.SocketBinding;

public class SocketBindingConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((String)"name", null, String.class).build();
    static final AttributeDefinition<Integer> PORT = AttributeDefinition.builder((String)"port", null, Integer.class).build();
    static final AttributeDefinition<String> INTERFACE = AttributeDefinition.builder((String)"interface", null, String.class).build();
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SOCKET_BINDING.toString());
    private final AttributeSet attributes;
    private final SocketBinding socketBinding;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SocketBindingConfiguration.class, new AttributeDefinition[]{NAME, PORT, INTERFACE});
    }

    SocketBindingConfiguration(AttributeSet attributes, SocketBinding socketBinding) {
        this.attributes = attributes.checkProtection();
        this.socketBinding = socketBinding;
    }

    SocketBinding getSocketBinding() {
        return this.socketBinding;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String interfaceName() {
        return (String)this.attributes.attribute(INTERFACE).get();
    }

    public Integer port() {
        return (Integer)this.attributes.attribute(PORT).get();
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocketBindingConfiguration that = (SocketBindingConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "SocketBindingConfiguration{attributes=" + this.attributes + '}';
    }
}

