/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.configuration.AddressConfiguration;
import org.infinispan.server.configuration.AddressType;

class AddressConfigurationBuilder
implements Builder<AddressConfiguration> {
    private final AttributeSet attributes = AddressConfiguration.attributeDefinitionSet();
    private AddressType addressType;

    AddressConfigurationBuilder() {
    }

    AddressConfigurationBuilder type(AddressType addressType, String value) {
        this.addressType = addressType;
        this.attributes.attribute(AddressConfiguration.VALUE).set((Object)value);
        return this;
    }

    AddressConfigurationBuilder type(AddressType addressType) {
        this.addressType = addressType;
        return this;
    }

    AddressType addressType() {
        return this.addressType;
    }

    public String value() {
        return (String)this.attributes.attribute(AddressConfiguration.VALUE).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressConfigurationBuilder that = (AddressConfigurationBuilder)o;
        if (!this.attributes.equals((Object)that.attributes)) {
            return false;
        }
        return this.addressType == that.addressType;
    }

    public int hashCode() {
        int result = this.attributes.hashCode();
        result = 31 * result + this.addressType.hashCode();
        return result;
    }

    public String toString() {
        return "InterfaceConfiguration{attributes=" + this.attributes + ", addressType=" + (Object)((Object)this.addressType) + '}';
    }

    public void validate() {
    }

    public AddressConfiguration create() {
        return new AddressConfiguration(this.attributes.protect(), this.addressType);
    }

    public AddressConfigurationBuilder read(AddressConfiguration template) {
        this.attributes.read(template.attributes());
        this.addressType = template.addressType();
        return this;
    }
}

