/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.DomainNameMapping;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.SniRouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;

public class SniRouteHandler
extends SniHandler {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private final RoutingTable routingTable;

    public SniRouteHandler(DomainNameMapping<? extends SslContext> mapping, RoutingTable routingTable) {
        super(mapping);
        this.routingTable = routingTable;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        super.decode(ctx, in, out);
        if (this.isHandShaked()) {
            logger.debugf("Handshaked with hostname %s", this.hostname());
            Optional<Route> route = this.routingTable.streamRoutes(SniRouteSource.class, HotRodServerRouteDestination.class).filter(r -> ((SniRouteSource)r.getRouteSource()).getSniHostName().equals(this.hostname())).findAny();
            HotRodServerRouteDestination routeDestination = (HotRodServerRouteDestination)route.orElseThrow(() -> logger.noRouteFound()).getRouteDesitnation();
            ChannelInitializer channelInitializer = routeDestination.getHotrodServer().getInitializer();
            ctx.pipeline().addLast(new ChannelHandler[]{channelInitializer});
            logger.debug("Replaced with route destination's handlers");
        }
    }

    public boolean isHandShaked() {
        return this.hostname() != null;
    }
}

