/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;

public class RoutingTable {
    private final Set<Route<? extends RouteSource, ? extends RouteDestination>> routes = new HashSet<Route<? extends RouteSource, ? extends RouteDestination>>();

    public RoutingTable(Set<Route<? extends RouteSource, ? extends RouteDestination>> routes) {
        this.routes.addAll(routes);
    }

    public int routesCount() {
        return this.routes.size();
    }

    public Stream<Route<? extends RouteSource, ? extends RouteDestination>> streamRoutes() {
        return this.routes.stream();
    }

    public <Source extends RouteSource, Destination extends RouteDestination> Stream<Route<Source, Destination>> streamRoutes(Class<Source> sourceType, Class<Destination> destinationType) {
        Stream<Route<Source, Destination>> unGenerifiedStream = this.routes.stream().filter(r -> sourceType.isAssignableFrom(r.getRouteSource().getClass())).filter(r -> destinationType.isAssignableFrom(r.getRouteDestination().getClass()));
        return unGenerifiedStream;
    }

    public String toString() {
        return "RoutingTable{routes=" + String.valueOf(this.routes) + "}";
    }
}

