/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration.builder;

import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.IpFilterConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfigurationBuilder;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.configuration.builder.AbstractRouterBuilder;
import org.infinispan.server.router.configuration.builder.ConfigurationBuilderParent;
import org.infinispan.server.router.logging.Log;

public class SinglePortRouterBuilder
extends AbstractRouterBuilder {
    private int sendBufferSize = 0;
    private int receiveBufferSize = 0;
    private String name = "single-port";
    private SSLContext sslContext;

    public SinglePortRouterBuilder(ConfigurationBuilderParent parent) {
        super(parent);
    }

    public SinglePortRouterConfiguration build() {
        if (this.enabled) {
            try {
                this.validate();
            }
            catch (Exception e) {
                throw Log.SERVER.configurationValidationError(e);
            }
            SslConfigurationBuilder sslConfigurationBuilder = new SslConfigurationBuilder(null);
            if (this.sslContext != null) {
                sslConfigurationBuilder.sslContext(this.sslContext).enable();
            }
            AttributeSet attributes = SinglePortRouterConfiguration.attributeDefinitionSet();
            attributes.attribute(ProtocolServerConfiguration.NAME).set((Object)this.name);
            attributes.attribute(ProtocolServerConfiguration.HOST).set((Object)this.ip.getHostName());
            attributes.attribute(ProtocolServerConfiguration.PORT).set((Object)this.port);
            attributes.attribute(ProtocolServerConfiguration.IDLE_TIMEOUT).set((Object)100);
            attributes.attribute(ProtocolServerConfiguration.RECV_BUF_SIZE).set((Object)this.receiveBufferSize);
            attributes.attribute(ProtocolServerConfiguration.SEND_BUF_SIZE).set((Object)this.sendBufferSize);
            return new SinglePortRouterConfiguration(attributes.protect(), sslConfigurationBuilder.create(), new IpFilterConfiguration(Collections.emptyList()));
        }
        return null;
    }

    public SinglePortRouterBuilder sendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
        return this;
    }

    public SinglePortRouterBuilder receiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
        return this;
    }

    public SinglePortRouterBuilder name(String name) {
        this.name = name;
        return this;
    }

    public SinglePortRouterBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.receiveBufferSize < 0) {
            throw new IllegalArgumentException("Receive buffer size can not be negative");
        }
        if (this.sendBufferSize < 0) {
            throw new IllegalArgumentException("Send buffer size can not be negative");
        }
    }
}

