/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.rest.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import java.util.Optional;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.Log;
import org.infinispan.server.router.routes.PrefixedRouteSource;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;

public class ChannelInboundHandlerDelegator
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final RoutingTable routingTable;

    public ChannelInboundHandlerDelegator(RoutingTable routingTable) {
        this.routingTable = routingTable;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        String[] uriSplitted = msg.uri().split("/");
        if (uriSplitted.length < 2) {
            throw Log.SERVER.noRouteFound();
        }
        String context = uriSplitted[2];
        Log.SERVER.debugf("Decoded context %s", context);
        Optional<Route> route = this.routingTable.streamRoutes(PrefixedRouteSource.class, RestServerRouteDestination.class).filter(r -> ((PrefixedRouteSource)r.getRouteSource()).getRoutePrefix().equals(context)).findAny();
        RestServerRouteDestination routeDestination = (RestServerRouteDestination)route.orElseThrow(Log.SERVER::noRouteFound).getRouteDestination();
        RestRequestHandler restHandler = (RestRequestHandler)((RestServer)routeDestination.getProtocolServer()).getRestChannelInitializer().getRestHandler();
        StringBuilder uriWithoutMultiTenantPrefix = new StringBuilder();
        for (int i = 0; i < uriSplitted.length; ++i) {
            if (i == 1) continue;
            uriWithoutMultiTenantPrefix.append(uriSplitted[i]);
            if (i >= uriSplitted.length - 1) continue;
            uriWithoutMultiTenantPrefix.append("/");
        }
        msg.setUri(uriWithoutMultiTenantPrefix.toString());
        restHandler.channelRead0(ctx, msg);
    }
}

