/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.infinispan.server.router.configuration.RouterConfiguration;
import org.infinispan.server.router.logging.Log;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.hotrod.HotRodEndpointRouter;
import org.infinispan.server.router.router.impl.rest.RestEndpointRouter;
import org.infinispan.server.router.router.impl.singleport.SinglePortEndpointRouter;

public class Router {
    private final RouterConfiguration routerConfiguration;
    private final Set<EndpointRouter> endpointRouters = new HashSet<EndpointRouter>();

    public Router(RouterConfiguration routerConfiguration) {
        this.routerConfiguration = routerConfiguration;
        if (routerConfiguration.hotRodRouter() != null) {
            this.endpointRouters.add(new HotRodEndpointRouter(routerConfiguration.hotRodRouter()));
        }
        if (routerConfiguration.restRouter() != null) {
            this.endpointRouters.add(new RestEndpointRouter(routerConfiguration.restRouter()));
        }
        if (routerConfiguration.singlePortRouter() != null) {
            this.endpointRouters.add(new SinglePortEndpointRouter(routerConfiguration.singlePortRouter()));
        }
    }

    public void start() {
        this.endpointRouters.forEach(r -> r.start(this.routerConfiguration.routingTable(), null));
        Log.SERVER.printOutRoutingTable(this.routerConfiguration.routingTable());
    }

    public void stop() {
        this.endpointRouters.forEach(r -> r.stop());
    }

    public Optional<EndpointRouter> getRouter(EndpointRouter.Protocol protocol) {
        return this.endpointRouters.stream().filter(r -> r.getProtocol() == protocol).findFirst();
    }
}

