/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.util.Mapping;
import java.util.List;
import java.util.Optional;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.logging.Log;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.SniRouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;

public class SniRouteHandler
extends SniHandler {
    private final RoutingTable routingTable;

    public SniRouteHandler(Mapping<String, SslContext> mapping, RoutingTable routingTable) {
        super(mapping);
        this.routingTable = routingTable;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        super.decode(ctx, in, out);
        if (this.isHandShaked()) {
            Log.SERVER.debugf("Handshaked with hostname %s", this.hostname());
            Optional<Route> route = this.routingTable.streamRoutes(SniRouteSource.class, HotRodServerRouteDestination.class).filter(r -> ((SniRouteSource)r.getRouteSource()).getSniHostName().equals(this.hostname())).findAny();
            HotRodServerRouteDestination routeDestination = (HotRodServerRouteDestination)route.orElseThrow(() -> Log.SERVER.noRouteFound()).getRouteDestination();
            ChannelInitializer channelInitializer = ((HotRodServer)routeDestination.getProtocolServer()).getInitializer();
            ctx.pipeline().addLast(new ChannelHandler[]{channelInitializer});
            Log.SERVER.debug("Replaced with route destination's handlers");
        }
    }

    public boolean isHandShaked() {
        return this.hostname() != null;
    }
}

