/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import java.util.ArrayList;
import java.util.Map;
import org.infinispan.rest.ALPNHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.ProtocolServer;

public class SinglePortUpgradeHandler
extends ALPNHandler {
    private final boolean useAlpn;
    private final Map<String, ProtocolServer> upgradeServers;

    public SinglePortUpgradeHandler(boolean useAlpn, RestServer restServer, Map<String, ProtocolServer> upgradeServers) {
        super(restServer);
        this.useAlpn = useAlpn;
        this.upgradeServers = upgradeServers;
    }

    protected ProtocolServer<?> getProtocolServer(String protocol) {
        return this.upgradeServers.get(protocol);
    }

    public ApplicationProtocolConfig getAlpnConfiguration() {
        if (this.useAlpn) {
            ArrayList<String> supportedProtocols = new ArrayList<String>();
            supportedProtocols.add("h2");
            supportedProtocols.add("http/1.1");
            supportedProtocols.addAll(this.upgradeServers.keySet());
            return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
        }
        return null;
    }

    public Map<String, ProtocolServer> getUpgradeServers() {
        return this.upgradeServers;
    }
}

