/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations;

import java.util.Collections;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.json.JsonQueryRequest;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.operations.AbstractOperations;
import org.infinispan.rest.search.InfinispanSearchRequest;
import org.infinispan.rest.search.InfinispanSearchResponse;

public class SearchOperations
extends AbstractOperations {
    public SearchOperations(RestServerConfiguration configuration, RestCacheManager<Object> cacheManager) {
        super(configuration, cacheManager);
    }

    public InfinispanSearchResponse search(String cacheName, JsonQueryRequest query, InfinispanSearchRequest request) {
        InfinispanSearchResponse searchResponse = InfinispanSearchResponse.inReplyTo(request);
        MediaType keyContentType = request.getKeyContentType();
        AdvancedCache cache = this.restCacheManager.getCache(cacheName, keyContentType, MediaType.APPLICATION_JSON, request.getSubject());
        String queryString = query.getQuery();
        try {
            RemoteQueryManager remoteQueryManager = (RemoteQueryManager)cache.getComponentRegistry().getComponent(RemoteQueryManager.class);
            byte[] queryResultBytes = remoteQueryManager.executeQuery(queryString, Collections.emptyMap(), query.getStartOffset(), query.getMaxResults(), query.getQueryMode(), cache, MediaType.APPLICATION_JSON);
            searchResponse.contentAsBytes(queryResultBytes);
            return searchResponse;
        }
        catch (IllegalArgumentException | IllegalStateException | ParsingException e) {
            return InfinispanSearchResponse.badRequest(request, "Error executing query", e.getMessage());
        }
    }
}

