/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import java.net.InetSocketAddress;
import java.util.Map;
import org.infinispan.util.logging.LogFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.MDC;

public class RestAccessLoggingHandler {
    private static final Logger log = LogFactory.getLogger((String)"REST_ACCESS_LOG");
    static final String X_REQUEST_TIME = "X-Request-Time";
    static final String X_FORWARDED_FOR = "X-Forwarded-For";
    static final String X_PRINCIPAL = "X-Principal";

    private boolean isEnabled() {
        return log.isTraceEnabled();
    }

    public void preLog(FullHttpRequest request) {
        if (this.isEnabled()) {
            request.headers().add(X_REQUEST_TIME, (Object)Long.toString(System.currentTimeMillis()));
        }
    }

    public void log(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        if (this.isEnabled()) {
            String who;
            String remoteAddress = request.headers().getAsString((CharSequence)X_FORWARDED_FOR);
            if (remoteAddress == null) {
                remoteAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
            }
            if ((who = request.headers().get(X_PRINCIPAL)) == null) {
                who = "-";
            }
            long now = System.currentTimeMillis();
            String requestTimeString = request.headers().get(X_REQUEST_TIME);
            long requestTime = requestTimeString != null ? Long.parseLong(requestTimeString) : now;
            String requestMethod = request.method().toString();
            String uri = request.uri();
            int status = response.status().code();
            int requestSize = request.content().readableBytes();
            int responseSize = response.content().readableBytes();
            long duration = now - requestTime;
            MDC.clear();
            for (Map.Entry s : request.headers().entries()) {
                MDC.put((String)("h:" + (String)s.getKey()), s.getValue());
            }
            MDC.put((String)"address", (Object)remoteAddress);
            MDC.put((String)"user", (Object)who);
            MDC.put((String)"method", (Object)requestMethod);
            MDC.put((String)"protocol", (Object)request.protocolVersion().text());
            MDC.put((String)"status", (Object)status);
            MDC.put((String)"responseSize", (Object)responseSize);
            MDC.put((String)"requestSize", (Object)requestSize);
            MDC.put((String)"duration", (Object)duration);
            log.tracef("%s", (Object)uri);
        }
    }
}

