/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.security.Security;

public abstract class InfinispanRequest {
    private static final String KEY_CONTENT_TYPE = "Key-Content-Type";
    private static final MediaType DEFAULT_KEY_CONTENT_TYPE = MediaType.parse((String)"application/x-java-object;type=java.lang.String");
    protected final FullHttpRequest request;
    private final Optional<String> streamId;
    private final ChannelHandlerContext nettyChannelContext;
    private final String cacheName;
    private final String context;
    protected Map<String, List<String>> parameters;
    private Subject subject;

    protected InfinispanRequest(FullHttpRequest request, ChannelHandlerContext ctx, String cacheName, String context, Map<String, List<String>> parameters) {
        this.request = request;
        this.streamId = Optional.ofNullable(request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text()));
        this.nettyChannelContext = ctx;
        this.cacheName = cacheName;
        this.context = context;
        this.parameters = parameters;
    }

    protected abstract InfinispanResponse execute();

    public Optional<String> getCacheName() {
        return Optional.ofNullable(this.cacheName);
    }

    Optional<String> getStreamId() {
        return this.streamId;
    }

    public FullHttpRequest getRawRequest() {
        return this.request;
    }

    public ChannelHandlerContext getRawContext() {
        return this.nettyChannelContext;
    }

    public Optional<Boolean> getUseAsync() {
        String performAsync = this.request.headers().get("performAsync");
        if ("true".equals(performAsync)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<String> getAcceptContentType() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.ACCEPT));
    }

    public MediaType getKeyContentType() {
        return Optional.ofNullable(this.request.headers().get(KEY_CONTENT_TYPE)).map(MediaType::parse).orElse(DEFAULT_KEY_CONTENT_TYPE);
    }

    public Optional<String> getContentType() {
        return Optional.ofNullable(this.request.headers().get("Content-type"));
    }

    public Optional<String> getAuthorization() {
        return Optional.ofNullable(this.request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION));
    }

    public String getContext() {
        return this.context;
    }

    public Optional<byte[]> data() {
        if (this.request.content() != null) {
            ByteBuf content = this.request.content();
            if (content.hasArray()) {
                return Optional.of(content.array());
            }
            byte[] bufferCopy = new byte[content.readableBytes()];
            content.readBytes(bufferCopy);
            return Optional.of(bufferCopy);
        }
        return Optional.empty();
    }

    public String getParameterValue(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.iterator().next();
    }

    public List<String> getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
        if (subject != null) {
            this.request.headers().add("X-Principal", (Object)Security.getSubjectUserPrincipal((Subject)subject).getName());
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String uri() {
        return this.request.uri();
    }

    public String method() {
        return this.request.method().name();
    }

    public List<String> headers(String s) {
        return this.request.headers().getAll(s);
    }

    public String header(String s) {
        return this.request.headers().get(s);
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Map<String, List<String>> getParameters() {
        return this.parameters;
    }
}

