/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.authentication.impl;

import io.netty.handler.ssl.SslHandler;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.authentication.AuthenticationException;
import org.infinispan.rest.authentication.Authenticator;

public class ClientCertAuthenticator
implements Authenticator {
    @Override
    public void challenge(InfinispanRequest request) throws RestResponseException {
        try {
            SslHandler sslHandler = (SslHandler)request.getRawContext().pipeline().get(SslHandler.class);
            SSLSession session = sslHandler.engine().getSession();
            Subject subject = new Subject();
            subject.getPrincipals().add(session.getPeerPrincipal());
            request.setSubject(subject);
            return;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            throw new AuthenticationException(Optional.empty());
        }
    }
}

