/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.Optional;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.operations.mediatypes.Charset;

public abstract class InfinispanResponse {
    private Optional<InfinispanRequest> request;
    private ByteBuf content = Unpooled.buffer();
    private String contentType;
    private HttpVersion httpVersion = HttpVersion.HTTP_1_1;
    private HttpResponseStatus httpStatus = HttpResponseStatus.OK;
    private Optional<String> authenticate = Optional.empty();
    private Optional<Charset> charset = Optional.empty();

    protected InfinispanResponse(Optional<InfinispanRequest> request) {
        this.request = request;
    }

    public void contentAsText(String content) {
        ByteBufUtil.writeUtf8((ByteBuf)this.content, (CharSequence)content);
    }

    public void contentAsBytes(byte[] content) {
        this.content.writeBytes(content);
    }

    public void contentType(String contentType) {
        this.contentType = contentType;
    }

    public void httpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void status(HttpResponseStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public boolean isKeepAlive() {
        boolean isKeepAlive = this.request.map(r -> HttpUtil.isKeepAlive((HttpMessage)r.getRawRequest())).orElse(false);
        return (this.httpVersion == HttpVersion.HTTP_1_1 || this.httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive;
    }

    protected void addSpecificHeaders(FullHttpResponse response) {
    }

    public FullHttpResponse toNettyHttpResponse() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.httpStatus, this.content);
        this.request.flatMap(InfinispanRequest::getStreamId).ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$1((FullHttpResponse)response, arg_0));
        if (this.isKeepAlive()) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.addSpecificHeaders((FullHttpResponse)response);
        this.authenticate.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$2((FullHttpResponse)response, arg_0));
        if (this.contentType != null) {
            StringBuilder contentTypeWithCharset = new StringBuilder(this.contentType);
            this.charset.ifPresent(charset -> contentTypeWithCharset.append(';').append(charset));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentTypeWithCharset.toString());
        }
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        return response;
    }

    public void authenticate(String authenticateHeader) {
        this.authenticate = Optional.of(authenticateHeader);
    }

    public void charset(Charset charset) {
        this.charset = Optional.ofNullable(charset);
    }

    public Optional<String> authenticateHeader() {
        return this.authenticate;
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$2(FullHttpResponse response, String e) {
        response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$1(FullHttpResponse response, String streamId) {
        response.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
    }
}

