/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.infinispan.rest.InfinispanErrorResponse;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanRequestFactory;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.context.WrongContextException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.util.logging.LogFactory;

public class Http20RequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    protected static final Log logger = (Log)LogFactory.getLog(Http20RequestHandler.class, Log.class);
    private final Authenticator authenticator;
    final RestAccessLoggingHandler restAccessLoggingHandler = new RestAccessLoggingHandler();
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;

    public Http20RequestHandler(RestServer restServer) {
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.authenticator = restServer.getAuthenticator();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        InfinispanResponse response;
        InfinispanRequest infinispanRequest = null;
        try {
            this.restAccessLoggingHandler.preLog(request);
            infinispanRequest = InfinispanRequestFactory.createRequest(this.restServer, request, ctx);
            this.checkContext(infinispanRequest);
            this.authenticator.challenge(infinispanRequest);
            response = infinispanRequest.execute();
        }
        catch (SecurityException securityException) {
            logger.errorWhileResponding(securityException);
            response = InfinispanErrorResponse.asError(infinispanRequest, HttpResponseStatus.FORBIDDEN, null);
        }
        catch (RestResponseException responseException) {
            logger.errorWhileResponding(responseException);
            response = responseException.toResponse(infinispanRequest);
        }
        this.sendResponse(ctx, request, response.toNettyHttpResponse());
    }

    private void checkContext(InfinispanRequest infinispanRequest) {
        if (this.configuration.startTransport() && !infinispanRequest.getContext().equals(this.configuration.contextPath())) {
            throw new WrongContextException();
        }
    }

    protected void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        ctx.executor().execute(() -> {
            this.restAccessLoggingHandler.log(ctx, request, response);
            ctx.writeAndFlush((Object)response);
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debug("Native IO Exception", e);
            ctx.close();
        } else {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

