/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Date;
import java.util.Optional;
import java.util.OptionalInt;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.operations.CacheOperationsHelper;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.infinispan.rest.operations.mediatypes.Charset;
import org.infinispan.rest.operations.mediatypes.MediaType;
import org.infinispan.rest.operations.mime.MimeMetadata;

public class CacheOperations {
    private static final MurmurHash3 hashFunc = MurmurHash3.getInstance();
    private final RestCacheManager<Object> restCacheManager;
    private final RestServerConfiguration restServerConfiguration;

    public CacheOperations(RestServerConfiguration configuration, RestCacheManager<Object> cacheManager) {
        this.restServerConfiguration = configuration;
        this.restCacheManager = cacheManager;
    }

    public InfinispanResponse getCacheValues(InfinispanRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            AdvancedCache<String, Object> cache = this.restCacheManager.getCache(cacheName);
            CacheSet keys = cache.keySet();
            MediaType mediaType = this.getMediaType(request);
            Charset charset = request.getAcceptContentType().map(m -> Charset.fromMediaType(m)).orElse(Charset.UTF8);
            InfinispanResponse response = InfinispanResponse.inReplyTo(request);
            response.contentType(mediaType.toString());
            response.charset(charset);
            response.cacheControl(CacheControl.noCache());
            response.contentAsBytes(mediaType.getOutputPrinter().print(cacheName, keys, charset));
            return response;
        }
        catch (CacheException cacheException) {
            throw new NoCacheFoundException(cacheException.getLocalizedMessage());
        }
    }

    public InfinispanResponse getCacheValue(InfinispanRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            String key = request.getKey().orElseThrow(NoKeyException::new);
            String cacheControl = request.getCacheControl().orElse("");
            boolean returnBody = request.getRawRequest().method() == HttpMethod.GET;
            CacheEntry<String, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key);
            MediaType mediaType = this.getMediaType(request);
            InfinispanResponse response = InfinispanResponse.inReplyTo(request);
            response.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                OptionalInt minFreshSeconds;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = CacheOperationsHelper.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                if (CacheOperationsHelper.entryFreshEnough(expires, minFreshSeconds = CacheOperationsHelper.minFresh(cacheControl))) {
                    String metadataContentType;
                    Metadata meta = ice.getMetadata();
                    if (meta instanceof MimeMetadata) {
                        metadataContentType = ((MimeMetadata)meta).contentType();
                        mediaType = MediaType.fromMediaTypeAsString(metadataContentType);
                    } else {
                        metadataContentType = mediaType.toString();
                    }
                    String etag = this.calcETAG(ice.getValue(), metadataContentType);
                    Charset charset = request.getAcceptContentType().map(m -> Charset.fromMediaType(metadataContentType)).orElse(Charset.UTF8);
                    if (CacheOperationsHelper.ifNoneMatchMathesEtag(request.getEtagIfNoneMatch(), etag)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifMatchDoesntMatchEtag(request.getEtagIfMatch(), etag)) {
                        response.status(HttpResponseStatus.PRECONDITION_FAILED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifUnmodifiedIsBeforeEntryModificationDate(request.getEtagIfUnmodifiedSince(), lastMod)) {
                        response.status(HttpResponseStatus.PRECONDITION_FAILED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifModifiedIsAfterEntryModificationDate(request.getEtagIfModifiedSince(), lastMod)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                    if (meta instanceof MimeMetadata) {
                        if (returnBody) {
                            Object valueFromCacheWithMetadata = ice.getValue();
                            if (valueFromCacheWithMetadata instanceof byte[]) {
                                response.contentAsBytes((byte[])ice.getValue());
                            } else {
                                response.contentAsText(ice.getValue().toString());
                            }
                        }
                    } else if (returnBody) {
                        response.contentAsBytes(mediaType.getOutputPrinter().print(ice.getValue(), charset));
                    }
                    response.status(HttpResponseStatus.OK);
                    response.contentType(metadataContentType);
                    if (mediaType != null && mediaType.needsCharset()) {
                        response.charset(charset);
                    }
                    response.lastModified(lastMod);
                    response.etag(etag);
                    response.cacheControl(CacheOperationsHelper.calcCacheControl(expires));
                    response.expires(expires);
                    response.timeToLive(meta.lifespan());
                    response.maxIdle(meta.maxIdle());
                    if (request.getExtended().isPresent() && CacheOperationsHelper.supportsExtendedHeaders(this.restServerConfiguration, request.getExtended().get())) {
                        response.clusterPrimaryOwner(this.restCacheManager.getPrimaryOwner(cacheName, key));
                        response.clusterNodeName(this.restCacheManager.getNodeName().toString());
                        response.clusterServerAddress(this.restCacheManager.getServerAddress());
                    }
                }
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw new NoCacheFoundException(cacheException.getLocalizedMessage());
        }
    }

    private MediaType getMediaType(InfinispanRequest request) throws UnacceptableDataFormatException {
        if (request.getAcceptContentType().isPresent()) {
            return request.getAcceptContentType().map(m -> MediaType.fromMediaTypeAsString(m)).orElseThrow(UnacceptableDataFormatException::new);
        }
        return MediaType.TEXT_PLAIN;
    }

    public InfinispanResponse deleteCacheValue(InfinispanRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            String key = request.getKey().orElseThrow(NoKeyException::new);
            Optional<Boolean> useAsync = request.getUseAsync();
            CacheEntry<String, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key);
            InfinispanResponse response = InfinispanResponse.inReplyTo(request);
            response.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Optional<String> clientEtag = request.getEtagIfNoneMatch();
                if (clientEtag.isPresent()) {
                    Metadata meta = entry.getMetadata();
                    if (meta instanceof MimeMetadata) {
                        String etag = this.calcETAG(ice.getValue(), ((MimeMetadata)meta).contentType());
                        if (clientEtag.get().equals(etag)) {
                            response.status(HttpResponseStatus.OK);
                            this.deleteCacheValue(cacheName, key, useAsync);
                        } else {
                            response.status(HttpResponseStatus.PRECONDITION_FAILED);
                        }
                    }
                } else {
                    response.status(HttpResponseStatus.OK);
                    this.deleteCacheValue(cacheName, key, useAsync);
                }
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw new NoCacheFoundException(cacheException.getLocalizedMessage());
        }
    }

    private void deleteCacheValue(String cacheName, String key, Optional<Boolean> useAsync) {
        if (useAsync.isPresent() && useAsync.get().booleanValue()) {
            this.restCacheManager.getCache(cacheName).removeAsync((Object)key);
        } else {
            this.restCacheManager.getCache(cacheName).remove((Object)key);
        }
    }

    public InfinispanResponse clearEntireCache(InfinispanRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            Optional<Boolean> useAsync = request.getUseAsync();
            InfinispanResponse response = InfinispanResponse.inReplyTo(request);
            response.status(HttpResponseStatus.OK);
            if (useAsync.isPresent() && useAsync.get().booleanValue()) {
                this.restCacheManager.getCache(cacheName).clearAsync();
            } else {
                this.restCacheManager.getCache(cacheName).clear();
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw new NoCacheFoundException(cacheException.getLocalizedMessage());
        }
    }

    public InfinispanResponse putValueToCache(InfinispanRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            AdvancedCache<String, Object> cache = this.restCacheManager.getCache(cacheName);
            String key = request.getKey().orElseThrow(NoKeyException::new);
            if (HttpMethod.POST.equals((Object)request.getRawRequest().method()) && cache.containsKey((Object)key)) {
                return InfinispanResponse.asError(request, HttpResponseStatus.CONFLICT, "An entry already exists");
            }
            InfinispanResponse response = InfinispanResponse.inReplyTo(request);
            Optional<Object> oldData = Optional.empty();
            byte[] data = request.data().orElseThrow(NoDataFoundException::new);
            CacheEntry<String, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key, true);
            if (entry instanceof InternalCacheEntry) {
                Metadata meta;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                oldData = Optional.of(entry.getValue());
                Optional<String> clientEtag = request.getEtagIfNoneMatch();
                if (clientEtag.isPresent() && (meta = ice.getMetadata()) instanceof MimeMetadata) {
                    String etag = this.calcETAG(ice.getValue(), ((MimeMetadata)meta).contentType());
                    if (clientEtag.get().equals(etag)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                }
            }
            boolean useAsync = request.getUseAsync().orElse(false);
            String dataType = request.getContentType().orElse("text/plain");
            Optional<Long> ttl = request.getTimeToLiveSeconds();
            Optional<Long> idle = request.getMaxIdleTimeSeconds();
            return this.putInCache(response, useAsync, cache, key, data, dataType, ttl, idle, oldData);
        }
        catch (CacheException cacheException) {
            throw new NoCacheFoundException(cacheException.getLocalizedMessage());
        }
    }

    private <V> String calcETAG(V value, String contentType) {
        return contentType + hashFunc.hash(value);
    }

    private InfinispanResponse putInCache(InfinispanResponse response, boolean useAsync, AdvancedCache<String, Object> cache, String key, byte[] data, String dataType, Optional<Long> ttl, Optional<Long> idleTime, Optional<Object> prevCond) {
        Metadata metadata = CacheOperationsHelper.createMetadata(cache.getCacheConfiguration(), dataType, ttl, idleTime);
        if (prevCond.isPresent()) {
            boolean replaced = cache.replace((Object)key, prevCond.get(), (Object)data, metadata);
            if (!replaced) {
                response.status(HttpResponseStatus.PRECONDITION_FAILED);
            }
        } else if (useAsync) {
            cache.putAsync((Object)key, (Object)data, metadata);
        } else {
            cache.put((Object)key, (Object)data, metadata);
        }
        response.etag(this.calcETAG(data, dataType));
        return response;
    }
}

