/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.logging.Log;

class CorsUtil {
    static final Log LOG = Log.getLog(CorsUtil.class);
    static final String[] SCHEMES = new String[]{"http", "https"};
    static final String ENABLE_ALL_FOR_ORIGIN_PROPERTY = "infinispan.server.rest.cors-allow";
    private static final List<CorsConfig> SYSTEM_CONFIG = new ArrayList<CorsConfig>();

    CorsUtil() {
    }

    static List<CorsConfig> enableAllForSystemConfig() {
        return SYSTEM_CONFIG;
    }

    static List<CorsConfig> enableAllForLocalHost(int ... ports) {
        ArrayList<CorsConfig> configs = new ArrayList<CorsConfig>();
        for (int port : ports) {
            for (String scheme : SCHEMES) {
                String localIpv4 = scheme + "://127.0.0.1:" + port;
                String localDomain = scheme + "://localhost:" + port;
                String localIpv6 = scheme + "://[::1]:" + port;
                configs.add(CorsUtil.enableAll(localIpv4));
                configs.add(CorsUtil.enableAll(localIpv6));
                configs.add(CorsUtil.enableAll(localDomain));
            }
        }
        return Collections.unmodifiableList(configs);
    }

    private static boolean isValidOrigin(String prop) {
        try {
            new URL(prop).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.invalidOrigin(prop, ENABLE_ALL_FOR_ORIGIN_PROPERTY);
            return false;
        }
        return true;
    }

    private static CorsConfig enableAll(String ... origins) {
        return CorsConfigBuilder.forOrigins((String[])origins).allowCredentials().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.OPTIONS}).allowedRequestHeaders(RequestHeader.toArray()).exposeHeaders(ResponseHeader.toArray()).build();
    }

    static {
        String originProp = System.getProperty(ENABLE_ALL_FOR_ORIGIN_PROPERTY);
        if (originProp != null) {
            Arrays.stream(originProp.split(",")).map(s -> s.replaceAll("\\s", "")).filter(CorsUtil::isValidOrigin).map(xva$0 -> CorsUtil.enableAll(xva$0)).forEach(SYSTEM_CONFIG::add);
        }
    }
}

