/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;

class ResourceUtil {
    ResourceUtil() {
    }

    static NettyRestResponse.Builder addEntityAsJson(Json json, NettyRestResponse.Builder responseBuilder, boolean pretty) {
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        return responseBuilder.entity(json.toString()).status(HttpResponseStatus.OK);
    }

    static RestResponse asJsonResponse(NettyRestResponse.Builder builder, Json json, boolean pretty) {
        return ResourceUtil.addEntityAsJson(json, builder, pretty).build();
    }

    static CompletableFuture<RestResponse> asJsonResponseFuture(NettyRestResponse.Builder builder, Json json, boolean pretty) {
        NettyRestResponse response = ResourceUtil.addEntityAsJson(json, builder, pretty).build();
        return CompletableFuture.completedFuture(response);
    }

    static NettyRestResponse.Builder addEntityAsJson(JsonSerialization o, NettyRestResponse.Builder responseBuilder) {
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        return responseBuilder.entity(o.toJson().toString()).status(HttpResponseStatus.OK);
    }

    static boolean isPretty(RestRequest request) {
        return Boolean.parseBoolean(request.getParameter("pretty"));
    }
}

