/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.HttpMessageUtil;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.rest.stream.CacheChunkedStream;
import org.infinispan.util.logging.LogFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ResponseWriter {
    EMPTY{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
            HttpResponse res = response.getResponse();
            HttpUtil.setContentLength((HttpMessage)res, (long)0L);
            this.log(ctx, request, res);
            ctx.writeAndFlush((Object)response.getResponse());
        }
    }
    ,
    FULL{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
            HttpResponse res = response.getResponse();
            ByteBuf responseContent = ((FullHttpResponse)res).content();
            Object entity = response.getEntity();
            if (entity instanceof byte[]) {
                responseContent.writeBytes((byte[])entity);
            } else if (entity instanceof ByteArrayOutputStream) {
                responseContent.writeBytes(((ByteArrayOutputStream)entity).toByteArray());
            } else {
                ByteBufUtil.writeUtf8((ByteBuf)responseContent, (CharSequence)entity.toString());
            }
            HttpUtil.setContentLength((HttpMessage)res, (long)responseContent.readableBytes());
            this.log(ctx, request, res);
            ctx.writeAndFlush((Object)res);
        }
    }
    ,
    CHUNKED_FILE{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile((File)response.getEntity(), "r");
                HttpResponse res = response.getResponse();
                this.log(ctx, request, res);
                res.headers().add(ResponseHeader.TRANSFER_ENCODING.getValue(), (Object)HttpHeaderValues.CHUNKED);
                res.headers().remove(ResponseHeader.CONTENT_LENGTH_HEADER.getValue());
                ctx.write((Object)res);
                ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(randomAccessFile, 0L, randomAccessFile.length(), 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
            catch (IOException e) {
                throw new RestResponseException(e);
            }
        }
    }
    ,
    CHUNKED_STREAM{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
            HttpResponse res = response.getResponse();
            res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            res.headers().remove(ResponseHeader.CONTENT_LENGTH_HEADER.getValue());
            res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.log(ctx, request, res);
            ctx.write((Object)res);
            CacheChunkedStream chunked = (CacheChunkedStream)response.getEntity();
            chunked.subscribe(ctx);
        }
    }
    ,
    EVENT_STREAM{

        @Override
        void writeResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
            HttpResponse res = response.getResponse();
            res.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)HttpHeaderValues.NO_CACHE);
            res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            res.headers().remove(ResponseHeader.CONTENT_LENGTH_HEADER.getValue());
            res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            this.log(ctx, request, res);
            ctx.writeAndFlush((Object)res).addListener(v -> {
                EventStream eventStream = (EventStream)response.getEntity();
                eventStream.setChannelHandlerContext(ctx);
            });
        }
    };

    static final Log logger;
    final RestAccessLoggingHandler accessLog = new RestAccessLoggingHandler();

    void log(ChannelHandlerContext ctx, FullHttpRequest req, HttpResponse rsp) {
        this.accessLog.log(ctx, req, rsp);
        if (logger.isTraceEnabled()) {
            logger.trace(HttpMessageUtil.dumpResponse(rsp));
        }
    }

    abstract void writeResponse(ChannelHandlerContext var1, FullHttpRequest var2, NettyRestResponse var3);

    static ResponseWriter forContent(FullHttpRequest request, Object content) {
        if (content == null || HttpMethod.HEAD.equals((Object)request.method())) {
            return EMPTY;
        }
        if (content instanceof File) {
            return CHUNKED_FILE;
        }
        if (content instanceof CacheChunkedStream) {
            return CHUNKED_STREAM;
        }
        if (content instanceof EventStream) {
            return EVENT_STREAM;
        }
        return FULL;
    }

    static {
        logger = (Log)LogFactory.getLog(ResponseWriter.class, Log.class);
    }
}

