/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.CompressionOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AsciiString;
import java.util.Collections;
import java.util.Map;
import org.infinispan.rest.CorsHandler;
import org.infinispan.rest.RestRequestHandler;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.StreamCorrelatorHandler;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.AccessControlFilter;

public class ALPNHandler
extends ApplicationProtocolNegotiationHandler {
    protected final RestServer restServer;

    public ALPNHandler(RestServer restServer) {
        super("http/1.1");
        this.restServer = restServer;
    }

    public void configurePipeline(ChannelHandlerContext ctx, String protocol) {
        ALPNHandler.configurePipeline(ctx.pipeline(), protocol, this.restServer, Collections.emptyMap());
    }

    public static void configurePipeline(ChannelPipeline pipeline, String protocol, RestServer restServer, Map<String, ProtocolServer<?>> upgradeServers) {
        if ("h2".equals(protocol) || "http/1.1".equals(protocol)) {
            ALPNHandler.configureHttpPipeline(pipeline, restServer);
            return;
        }
        ProtocolServer<?> protocolServer = upgradeServers.get(protocol);
        if (protocolServer != null) {
            pipeline.addLast(new ChannelHandler[]{protocolServer.getInitializer()});
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    private static void addCommonHandlers(ChannelPipeline pipeline, RestServer restServer) {
        RestServerConfiguration configuration = (RestServerConfiguration)restServer.getConfiguration();
        pipeline.addLast(new ChannelHandler[]{new AccessControlFilter((ProtocolServerConfiguration)configuration, false)});
        pipeline.addLast(new ChannelHandler[]{new HttpContentCompressor(configuration.getCompressionThreshold(), new CompressionOptions[]{StandardCompressionOptions.deflate((int)configuration.getCompressionLevel(), (int)15, (int)8), StandardCompressionOptions.gzip((int)configuration.getCompressionLevel(), (int)15, (int)8)})});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(restServer.maxContentLength())});
        pipeline.addLast(new ChannelHandler[]{new StreamCorrelatorHandler()});
        pipeline.addLast(new ChannelHandler[]{new CorsHandler(restServer.getCorsConfigs(), true)});
        pipeline.addLast(new ChannelHandler[]{new HttpServerKeepAliveHandler()});
        pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        pipeline.addLast(new ChannelHandler[]{new RestRequestHandler(restServer)});
    }

    private static void configureHttpPipeline(ChannelPipeline pipeline, final RestServer restServer) {
        final Http2FrameCodec h2c = Http2FrameCodecBuilder.forServer().initialSettings(Http2Settings.defaultSettings()).build();
        final Http2MultiplexHandler multiplexCodec = new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline p = channel.pipeline();
                p.addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)});
                ALPNHandler.addCommonHandlers(p, restServer);
            }
        });
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(h2c, new ChannelHandler[]{multiplexCodec});
            }
            return null;
        };
        HttpServerCodec httpCodec = new HttpServerCodec(4096, 8192, restServer.maxContentLength());
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)httpCodec, upgradeCodecFactory, restServer.maxContentLength());
        CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpCodec, upgradeHandler, new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) {
                ctx.pipeline().addAfter(ctx.name(), null, (ChannelHandler)h2c);
                String name = ctx.pipeline().context((ChannelHandler)h2c).name();
                ctx.pipeline().addAfter(name, null, (ChannelHandler)multiplexCodec);
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
            }

            @Deprecated
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            }
        });
        pipeline.addLast(new ChannelHandler[]{cleartextHttp2ServerUpgradeHandler});
        ALPNHandler.addCommonHandlers(pipeline, restServer);
    }
}

