/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;

public class TasksResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;

    public TasksResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/tasks/").handleWith(this::listTasks).invocation().methods(Method.PUT, Method.POST).path("/v2/tasks/{taskName}").handleWith(this::createScriptTask).invocation().methods(Method.POST).path("/v2/tasks/{taskName}").withAction("exec").handleWith(this::runTask).invocation().methods(Method.GET).path("/v2/tasks/{taskName}").withAction("script").handleWith(this::getScript).create();
    }

    private CompletionStage<RestResponse> getScript(RestRequest request) {
        String taskName = request.variables().get("taskName");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance().withSubject(request.getSubject());
        ScriptingManager scriptingManager = (ScriptingManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(ScriptingManager.class);
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        if (!scriptingManager.getScriptNames().contains(taskName)) {
            throw Log.REST.noSuchScript(taskName);
        }
        return CompletableFuture.supplyAsync(() -> {
            String script = (String)Security.doAs((Subject)request.getSubject(), () -> scriptingManager.getScript(taskName));
            return builder.entity(script).contentType("text/plain").build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> listTasks(RestRequest request) {
        String type = request.getParameter("type");
        boolean userOnly = "user".equalsIgnoreCase(type);
        boolean pretty = ResourceUtil.isPretty(request);
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(TaskManager.class);
        return (userOnly ? taskManager.getUserTasksAsync() : taskManager.getTasksAsync()).thenApply(tasks -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.make((Object)tasks), pretty));
    }

    private CompletionStage<RestResponse> createScriptTask(RestRequest request) {
        String taskName = request.variables().get("taskName");
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance().withSubject(request.getSubject());
        ScriptingManager scriptingManager = (ScriptingManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(ScriptingManager.class);
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        MediaType sourceType = request.contentType() == null ? MediaType.APPLICATION_JAVASCRIPT : request.contentType();
        String script = StandardConversions.convertTextToObject((Object)bytes, (MediaType)sourceType);
        return CompletableFuture.supplyAsync(() -> {
            Security.doAs((Subject)request.getSubject(), () -> scriptingManager.addScript(taskName, script));
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> runTask(RestRequest request) {
        String taskName = request.variables().get("taskName");
        boolean pretty = ResourceUtil.isPretty(request);
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        TaskManager taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getComponent(TaskManager.class);
        TaskContext taskContext = new TaskContext();
        request.parameters().forEach((k, v) -> {
            if ("cache".equals(k)) {
                AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache((String)v.get(0), request);
                taskContext.cache(cache);
            } else if (k.startsWith("param.")) {
                taskContext.addParameter(k.substring(6), v.get(0));
            }
        });
        CompletionStage runResult = (CompletionStage)Security.doAs((Subject)request.getSubject(), () -> taskManager.runTask(taskName, taskContext));
        return runResult.thenApply(result -> {
            NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
            if (result instanceof byte[]) {
                builder.contentType("text/plain").entity(result);
            } else {
                ResourceUtil.addEntityAsJson(Json.make((Object)result), builder, pretty);
            }
            return builder.build();
        });
    }
}

