/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.hibernate.search.util.common.function.TriFunction;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.Health;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ConfigurationChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ConfigurationChangedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ServerSentEvent;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.BackupManagerResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.ServerManagement;
import org.infinispan.stats.CacheContainerStats;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.annotation.impl.Logged;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogSerializer;

public class ContainerResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final InternalCacheRegistry internalCacheRegistry;
    private final ParserRegistry parserRegistry = new ParserRegistry();
    private final String cacheManagerName;

    public ContainerResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        EmbeddedCacheManager cacheManager = invocationHelper.getRestCacheManager().getInstance();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)cacheManager);
        this.cacheManagerName = globalConfiguration.cacheManagerName();
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager);
        this.internalCacheRegistry = (InternalCacheRegistry)globalComponentRegistry.getComponent(InternalCacheRegistry.class);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.HEAD).path("/v2/cache-managers/{name}/health").deprecated().handleWith(this::getHealth).invocation().methods(Method.GET, Method.HEAD).path("/v2/container/health").deprecated().handleWith(this::getHealth).invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/v2/cache-managers/{name}/health/status").deprecated().handleWith(this::getHealthStatus).invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/v2/container/health/status").handleWith(this::getHealthStatus).invocation().methods(Method.GET).deprecated().path("/v2/cache-managers/{name}/cache-configs").handleWith(this::getAllCachesConfiguration).invocation().methods(Method.GET).deprecated().path("/v2/cache-managers/{name}/cache-configs/templates").handleWith(this::getAllCachesConfigurationTemplates).invocation().methods(Method.POST).deprecated().path("/v2/cache-managers/{name}/config").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).path("/v2/container/cache-configs").handleWith(this::getAllCachesConfiguration).invocation().methods(Method.GET).path("/v2/container/cache-configs/templates").handleWith(this::getAllCachesConfigurationTemplates).invocation().methods(Method.POST).path("/v2/container/cache-configs/config").withAction("toJSON").handleWith(this::convertToJson).invocation().methods(Method.GET).deprecated().path("/v2/cache-managers/{name}/config").handleWith(this::getConfig).invocation().methods(Method.GET).path("/v2/container/config").handleWith(this::getConfig).invocation().methods(Method.POST).path("/v2/container").withAction("shutdown").name("SHUTDOWN CONTAINER").auditContext(AuditContext.CACHEMANAGER).handleWith(this::shutdown).invocation().methods(Method.GET).path("/v2/container/config").withAction("listen").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::listenConfig).invocation().method(Method.GET).path("/v2/container").withAction("listen").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).handleWith(this::listenLifecycle).invocation().methods(Method.GET).path("/v2/cache-managers/{name}").deprecated().handleWith(this::getInfo).invocation().methods(Method.GET).path("/v2/container").handleWith(this::getInfo).invocation().methods(Method.POST).path("/v2/cache-managers/{name}").withAction("enable-rebalancing").permission(AuthorizationPermission.ADMIN).name("ENABLE REBALANCE GLOBAL").auditContext(AuditContext.CACHEMANAGER).deprecated().handleWith(r -> this.setRebalancing(true, (RestRequest)r)).invocation().methods(Method.POST).path("/v2/container").withAction("enable-rebalancing").permission(AuthorizationPermission.ADMIN).name("ENABLE REBALANCE GLOBAL").auditContext(AuditContext.CACHEMANAGER).handleWith(r -> this.setRebalancing(true, (RestRequest)r)).invocation().methods(Method.POST).path("/v2/cache-managers/{name}").withAction("disable-rebalancing").permission(AuthorizationPermission.ADMIN).name("DISABLE REBALANCE GLOBAL").auditContext(AuditContext.CACHEMANAGER).deprecated().handleWith(r -> this.setRebalancing(false, (RestRequest)r)).invocation().methods(Method.POST).path("/v2/container").withAction("disable-rebalancing").permission(AuthorizationPermission.ADMIN).name("DISABLE REBALANCE GLOBAL").auditContext(AuditContext.CACHEMANAGER).handleWith(r -> this.setRebalancing(false, (RestRequest)r)).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/stats").deprecated().handleWith(this::getStats).invocation().methods(Method.POST).path("/v2/cache-managers/{name}/stats").deprecated().withAction("reset").permission(AuthorizationPermission.ADMIN).handleWith(this::resetStats).invocation().methods(Method.GET).path("/v2/container/stats").handleWith(this::getStats).invocation().methods(Method.POST).path("/v2/container/stats").withAction("reset").permission(AuthorizationPermission.ADMIN).handleWith(this::resetStats).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/backups").deprecated().handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.HEAD, Method.POST).path("/v2/cache-managers/{name}/backups/{backupName}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").deprecated().handleWith(this::backup).invocation().methods(Method.GET).path("/v2/cache-managers/{name}/restores").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").deprecated().handleWith(this::getAllRestoreNames).invocation().methods(Method.DELETE, Method.HEAD, Method.POST).path("/v2/cache-managers/{name}/restores/{restoreName}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").deprecated().handleWith(this::restore).invocation().methods(Method.GET).path("/v2/container/backups").handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.HEAD, Method.POST).path("/v2/container/backups/{backupName}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").handleWith(this::backup).invocation().methods(Method.GET).path("/v2/container/restores").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").handleWith(this::getAllRestoreNames).invocation().methods(Method.DELETE, Method.HEAD, Method.POST).path("/v2/container/restores/{restoreName}").permission(AuthorizationPermission.ADMIN).auditContext(AuditContext.SERVER).name("BACKUP").handleWith(this::restore).create();
    }

    private CompletionStage<RestResponse> getInfo(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        Json cacheManagerInfo = cacheManager.getCacheManagerInfo().toJson();
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), cacheManagerInfo, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable, RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
                SecurityActions.getGlobalComponentRegistry((EmbeddedCacheManager)cacheManager).getLocalTopologyManager().setRebalancingEnabled(enable);
                responseBuilder.status(HttpResponseStatus.NO_CONTENT);
            }
            catch (Exception e) {
                throw Util.unchecked((Throwable)e);
            }
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getConfig(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager embeddedCacheManager = this.invocationHelper.getRestCacheManager().getInstance().withSubject(request.getSubject());
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration((EmbeddedCacheManager)embeddedCacheManager);
        MediaType format = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)baos).withType(format).prettyPrint(ResourceUtil.isPretty(request)).build();){
                this.parserRegistry.serialize(writer, globalConfiguration, Collections.emptyMap());
            }
            responseBuilder.contentType(format);
            responseBuilder.entity(baos.toByteArray());
        }
        catch (Exception e) {
            throw Util.unchecked((Throwable)e);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        return CompletableFuture.supplyAsync(() -> ((CacheContainerStats)Security.doAs((Subject)request.getSubject(), () -> ((EmbeddedCacheManager)cacheManager).getStats())).toJson(), this.invocationHelper.getExecutor()).thenCompose(json -> ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), json, ResourceUtil.isPretty(request)));
    }

    private CompletionStage<RestResponse> resetStats(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        return CompletableFuture.supplyAsync(() -> {
            Security.doAs((Subject)request.getSubject(), () -> cacheManager.getStats().reset());
            return this.invocationHelper.newResponse(request, HttpResponseStatus.NO_CONTENT);
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getHealth(RestRequest request) {
        return this.getHealth(request, false);
    }

    private CompletionStage<RestResponse> getHealthStatus(RestRequest request) {
        return this.getHealth(request, true);
    }

    private CompletionStage<RestResponse> getHealth(RestRequest request, boolean anon) {
        boolean isStopping;
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        boolean bl = isStopping = anon && this.invocationHelper.getServer().getStatus().isStopping();
        if (request.method() == Method.HEAD || isStopping) {
            return CompletableFuture.completedFuture(this.invocationHelper.newResponse(request).status(HttpResponseStatus.OK).build());
        }
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        Health health = cacheManager.withSubject(request.getSubject()).getHealth();
        HealthInfo healthInfo = new HealthInfo(health.getClusterHealth(), health.getCacheHealth());
        if (anon) {
            responseBuilder.contentType(MediaType.TEXT_PLAIN).entity(Security.doAs((Subject)request.getSubject(), () -> healthInfo.clusterHealth.getHealthStatus().toString())).status(HttpResponseStatus.OK);
        } else {
            ResourceUtil.addEntityAsJson(healthInfo.toJson(), responseBuilder, ResourceUtil.isPretty(request));
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> getAllCachesConfiguration(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        boolean pretty = ResourceUtil.isPretty(request);
        EmbeddedCacheManager subjectCacheManager = this.invocationHelper.getRestCacheManager().getInstance().withSubject(request.getSubject());
        Set cacheConfigurationNames = subjectCacheManager.getCacheConfigurationNames();
        List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).distinct().map(n -> this.getNamedCacheConfiguration(subjectCacheManager, (String)n, pretty)).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(configurations), pretty);
    }

    private CompletionStage<RestResponse> getAllCachesConfigurationTemplates(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        boolean pretty = ResourceUtil.isPretty(request);
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        EmbeddedCacheManager subjectCacheManager = cacheManager.withSubject(request.getSubject());
        Set cacheConfigurationNames = subjectCacheManager.getCacheConfigurationNames();
        List configurations = cacheConfigurationNames.stream().filter(n -> !this.internalCacheRegistry.isInternalCache(n)).filter(n -> SecurityActions.getCacheConfiguration((EmbeddedCacheManager)subjectCacheManager, (String)n).isTemplate()).distinct().map(n -> this.getNamedCacheConfiguration(subjectCacheManager, (String)n, pretty)).sorted(Comparator.comparing(c -> c.name)).collect(Collectors.toList());
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make(configurations), pretty);
    }

    private NamedCacheConfiguration getNamedCacheConfiguration(EmbeddedCacheManager subjectCacheManager, String n, boolean pretty) {
        Configuration config = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)subjectCacheManager, (String)n);
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(pretty).build();){
            this.invocationHelper.getParserRegistry().serialize(w, n, config);
        }
        return new NamedCacheConfiguration(n, sw.toString());
    }

    private CompletionStage<RestResponse> getAllBackupNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = backupManager.getBackupNames();
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)names), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> backup(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        return BackupManagerResource.handleBackupRequest(this.invocationHelper, request, backupManager, (TriConsumer<String, Path, Json>)((TriConsumer)(name, workingDir, json) -> {
            BackupManager.Resources resources = BackupManagerResource.getResources(json);
            Map<String, BackupManager.Resources> backupParams = Collections.singletonMap(this.cacheManagerName, resources);
            backupManager.create(name, workingDir, backupParams);
        }));
    }

    private CompletionStage<RestResponse> getAllRestoreNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = backupManager.getRestoreNames();
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), Json.make((Object)names), ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> restore(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        return BackupManagerResource.handleRestoreRequest(this.invocationHelper, request, backupManager, (TriFunction<String, Path, Json, CompletionStage<Void>>)((TriFunction)(name, path, json) -> {
            BackupManager.Resources resources = BackupManagerResource.getResources(json);
            Map<String, BackupManager.Resources> restoreParams = Collections.singletonMap(this.cacheManagerName, resources);
            return backupManager.restore(name, path, restoreParams);
        }));
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        if (responseBuilder.getHttpStatus() == HttpResponseStatus.NOT_FOUND) {
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        ContentSource contents = request.contents();
        ConfigurationBuilderHolder builderHolder = this.parserRegistry.parse(new String(contents.rawContent(), StandardCharsets.UTF_8));
        Map.Entry entry = builderHolder.getNamedConfigurationBuilders().entrySet().iterator().next();
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).prettyPrint(ResourceUtil.isPretty(request)).build();){
            this.invocationHelper.getParserRegistry().serialize(w, (String)entry.getKey(), ((ConfigurationBuilder)entry.getValue()).build());
        }
        responseBuilder.contentType(MediaType.APPLICATION_JSON).entity(sw.toString());
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletionStage<RestResponse> shutdown(RestRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Security.doAs((Subject)request.getSubject(), () -> ((ServerManagement)this.invocationHelper.getServer()).containerStop());
            return this.invocationHelper.newResponse(request).status(HttpResponseStatus.NO_CONTENT).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> listenConfig(RestRequest request) {
        return this.streamConfigurationAndEvents(request, false);
    }

    private CompletionStage<RestResponse> listenLifecycle(RestRequest request) {
        return this.streamConfigurationAndEvents(request, true);
    }

    private CompletionStage<RestResponse> streamConfigurationAndEvents(RestRequest request, boolean includeLifecycle) {
        MediaType mediaType = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_YAML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML);
        boolean includeCurrentState = Boolean.parseBoolean(request.getParameter("includeCurrentState"));
        boolean pretty = ResourceUtil.isPretty(request);
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
        ConfigurationListener listener = new ConfigurationListener(cacheManager, mediaType, includeCurrentState, pretty);
        responseBuilder.contentType(MediaType.TEXT_EVENT_STREAM).entity(listener.getEventStream());
        CompletionStage<RestResponse> cs = SecurityActions.addListenerAsync((EmbeddedCacheManager)cacheManager, (Object)listener);
        if (includeLifecycle) {
            cs = cs.thenCompose(ignore -> SecurityActions.addLoggerListenerAsync((EmbeddedCacheManager)cacheManager, (Object)listener));
        }
        return cs.thenApply(v -> responseBuilder.build());
    }

    private String serializeConfig(Configuration cacheConfiguration, String name, MediaType mediaType, boolean pretty) {
        StringWriter sw = new StringWriter();
        try (ConfigurationWriter writer = ConfigurationWriter.to((Writer)sw).withType(mediaType).prettyPrint(pretty).build();){
            this.parserRegistry.serialize(writer, null, Collections.singletonMap(name, cacheConfiguration));
        }
        return sw.toString();
    }

    private String serializeEvent(EventLog event, MediaType mediaType, boolean pretty) {
        StringWriter sw = new StringWriter();
        try (ConfigurationWriter writer = ConfigurationWriter.to((Writer)sw).withType(mediaType).prettyPrint(pretty).build();){
            this.parserRegistry.serializeWith(writer, (ConfigurationSerializer)new EventLogSerializer(), (Object)event);
        }
        return sw.toString();
    }

    static class HealthInfo
    implements JsonSerialization {
        private final ClusterHealth clusterHealth;
        private final List<CacheHealth> cacheHealth;

        HealthInfo(ClusterHealth clusterHealth, List<CacheHealth> cacheHealth) {
            this.clusterHealth = clusterHealth;
            this.cacheHealth = cacheHealth;
        }

        public Json toJson() {
            return Json.object().set("cluster_health", this.clusterHealth.toJson()).set("cache_health", Json.make(this.cacheHealth));
        }
    }

    static class NamedCacheConfiguration
    implements JsonSerialization {
        String name;
        String configuration;

        NamedCacheConfiguration(String name, String configuration) {
            this.name = name;
            this.configuration = configuration;
        }

        public Json toJson() {
            return Json.object().set("name", (Object)this.name).set("configuration", Json.factory().raw(this.configuration));
        }
    }

    @Listener
    public class ConfigurationListener {
        final EmbeddedCacheManager cacheManager;
        final EventStream eventStream;
        final MediaType mediaType;
        private final boolean pretty;

        protected ConfigurationListener(EmbeddedCacheManager cacheManager, MediaType mediaType, boolean includeCurrentState, boolean pretty) {
            this.cacheManager = cacheManager;
            this.mediaType = mediaType;
            this.pretty = pretty;
            this.eventStream = new EventStream(includeCurrentState ? stream -> {
                for (String configName : cacheManager.getCacheConfigurationNames()) {
                    Configuration config = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)cacheManager, (String)configName);
                    String eventType = config.isTemplate() ? "create-template" : "create-cache";
                    stream.sendEvent(new ServerSentEvent(eventType, ContainerResource.this.serializeConfig(config, configName, mediaType, pretty)));
                }
            } : null, () -> Security.doPrivileged(() -> cacheManager.removeListenerAsync((Object)this)));
        }

        public EventStream getEventStream() {
            return this.eventStream;
        }

        @Logged
        public CompletionStage<Void> onDataLogged(EventLog event) {
            if (event.getCategory() != EventLogCategory.LIFECYCLE) {
                return CompletableFutures.completedNull();
            }
            ServerSentEvent sse = new ServerSentEvent("lifecycle-event", ContainerResource.this.serializeEvent(event, this.mediaType, this.pretty));
            return this.eventStream.sendEvent(sse);
        }

        @ConfigurationChanged
        public CompletionStage<Void> onConfigurationEvent(ConfigurationChangedEvent event) {
            ServerSentEvent sse;
            String eventType = event.getConfigurationEventType().toString().toLowerCase() + "-" + event.getConfigurationEntityType();
            if (event.getConfigurationEventType() == ConfigurationChangedEvent.EventType.REMOVE) {
                sse = new ServerSentEvent(eventType, event.getConfigurationEntityName());
            } else {
                switch (event.getConfigurationEntityType()) {
                    case "cache": 
                    case "template": {
                        Configuration config = SecurityActions.getCacheConfiguration((EmbeddedCacheManager)this.cacheManager, (String)event.getConfigurationEntityName());
                        sse = new ServerSentEvent(eventType, ContainerResource.this.serializeConfig(config, event.getConfigurationEntityName(), this.mediaType, this.pretty));
                        break;
                    }
                    default: {
                        return CompletableFutures.completedNull();
                    }
                }
            }
            return this.eventStream.sendEvent(sse);
        }
    }
}

