/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.ResourceManager;
import org.infinispan.rest.framework.impl.PathItem;
import org.infinispan.rest.framework.impl.ResourceNode;
import org.infinispan.rest.framework.impl.StringPathItem;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ResourceManagerImpl
implements ResourceManager {
    private static final Log logger = (Log)LogFactory.getLog(ResourceManagerImpl.class, Log.class);
    private static final StringPathItem ROOT = new StringPathItem("/");
    private final ResourceNode resourceTree = new ResourceNode(ROOT, null);

    @Override
    public void registerResource(String context, ResourceHandler handler) throws RegistrationException {
        handler.getInvocations().forEach(invocation -> {
            Set<String> paths = invocation.paths();
            paths.forEach(path -> {
                this.validate((String)path);
                List<PathItem> p = Arrays.stream(path.split("/")).filter(s -> !s.isEmpty()).map(PathItem::fromString).toList();
                ArrayList<PathItem> pathWithCtx = new ArrayList<PathItem>();
                pathWithCtx.add(new StringPathItem(context));
                pathWithCtx.addAll(p);
                this.resourceTree.insertPath((Invocation)invocation, (List<PathItem>)pathWithCtx);
            });
        });
    }

    private void validate(String path) {
        if (path.contains("*") && !path.endsWith("*")) {
            throw logger.invalidPath(path);
        }
    }

    @Override
    public LookupResult lookupResource(Method method, String path, String action) {
        ArrayList<PathItem> pathItems = new ArrayList<PathItem>();
        int l = path.length();
        int s = 0;
        int pos = 0;
        while (pos < l) {
            char ch = path.charAt(pos);
            if (ch == '/') {
                if (pos == 0) {
                    pathItems.add(ROOT);
                } else if (pos > s) {
                    pathItems.add(new StringPathItem(QueryStringDecoder.decodeComponent((String)path.substring(s, pos))));
                }
                s = ++pos;
                continue;
            }
            ++pos;
        }
        if (s < pos) {
            pathItems.add(new StringPathItem(QueryStringDecoder.decodeComponent((String)path.substring(s))));
        }
        return this.resourceTree.find(method, pathItems, action);
    }
}

