/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.authentication.RestAuthenticator;
import org.infinispan.rest.configuration.RestAuthenticationConfiguration;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.AbstractProtocolServerConfigurationChildBuilder;
import org.infinispan.server.core.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationChildBuilder;

public class RestAuthenticationConfigurationBuilder
extends AbstractProtocolServerConfigurationChildBuilder<RestServerConfiguration, RestAuthenticationConfigurationBuilder, RestAuthenticationConfiguration>
implements AuthenticationConfigurationBuilder<RestAuthenticationConfiguration> {
    private final AttributeSet attributes = RestAuthenticationConfiguration.attributeDefinitionSet();
    private RestAuthenticator authenticator;
    private boolean enabled;

    RestAuthenticationConfigurationBuilder(ProtocolServerConfigurationBuilder builder) {
        super((ProtocolServerConfigurationChildBuilder)builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RestAuthenticationConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public RestAuthenticationConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public RestAuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public RestAuthenticationConfigurationBuilder securityRealm(String realm) {
        this.attributes.attribute(RestAuthenticationConfiguration.SECURITY_REALM).set((Object)realm);
        return this;
    }

    public String securityRealm() {
        return (String)this.attributes.attribute(RestAuthenticationConfiguration.SECURITY_REALM).get();
    }

    public boolean hasSecurityRealm() {
        return !this.attributes.attribute(RestAuthenticationConfiguration.SECURITY_REALM).isNull();
    }

    public RestAuthenticationConfigurationBuilder authenticator(RestAuthenticator authenticator) {
        this.authenticator = authenticator;
        return this.enable();
    }

    public RestAuthenticationConfigurationBuilder addMechanisms(String ... mechanisms) {
        List mechs = (List)this.attributes.attribute(RestAuthenticationConfiguration.MECHANISMS).get();
        Collections.addAll(mechs, mechanisms);
        this.attributes.attribute(RestAuthenticationConfiguration.MECHANISMS).set((Object)mechs);
        return this.enable();
    }

    public boolean hasMechanisms() {
        return !((List)this.attributes.attribute(RestAuthenticationConfiguration.MECHANISMS).get()).isEmpty();
    }

    public List<String> mechanisms() {
        return (List)this.attributes.attribute(RestAuthenticationConfiguration.MECHANISMS).get();
    }

    public RestAuthenticationConfigurationBuilder metricsAuth(boolean metricsAuth) {
        this.attributes.attribute(RestAuthenticationConfiguration.METRICS_AUTH).set((Object)metricsAuth);
        return this;
    }

    public void validate() {
        if (this.enabled && this.authenticator == null) {
            throw RestServerConfigurationBuilder.logger.authenticationWithoutAuthenticator();
        }
    }

    public RestAuthenticationConfiguration create() {
        return new RestAuthenticationConfiguration(this.attributes.protect(), this.authenticator, this.enabled);
    }

    public Builder<?> read(RestAuthenticationConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public RestAuthenticationConfigurationBuilder self() {
        return this;
    }
}

