/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.util.common.function.TriFunction;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.BackupManager;
import org.infinispan.server.core.backup.BackupManagerResources;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.LogFactory;

class BackupManagerResource {
    private static final Log LOG = (Log)LogFactory.getLog(BackupManagerResource.class, Log.class);
    private static final String DIR_KEY = "directory";
    private static final String LOCATION_KEY = "location";
    private static final String RESOURCES_KEY = "resources";

    BackupManagerResource() {
    }

    static CompletionStage<RestResponse> handleBackupRequest(InvocationHelper invocationHelper, RestRequest request, BackupManager backupManager, TriConsumer<String, Path, Json> creationConsumer) {
        String name = request.variables().get("backupName");
        Method method = request.method();
        switch (method) {
            case DELETE: {
                return BackupManagerResource.handleDeleteBackup(invocationHelper, name, request, backupManager);
            }
            case GET: 
            case HEAD: {
                return BackupManagerResource.handleGetBackup(invocationHelper, name, request, backupManager, method);
            }
            case POST: {
                return BackupManagerResource.handleCreateBackup(invocationHelper, name, request, backupManager, creationConsumer);
            }
        }
        throw Log.REST.wrongMethod(method.toString());
    }

    private static CompletionStage<RestResponse> handleCreateBackup(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager, TriConsumer<String, Path, Json> creationConsumer) {
        Path workingDir;
        BackupManager.Status existingStatus = backupManager.getBackupStatus(name);
        if (existingStatus != BackupManager.Status.NOT_FOUND) {
            return invocationHelper.newResponse(request, HttpResponseStatus.CONFLICT).toFuture();
        }
        String body = request.contents().asString();
        Json json = !body.isEmpty() ? Json.read((String)body) : Json.object();
        Json dirJson = json.at(DIR_KEY);
        Path path = workingDir = dirJson == null ? null : Paths.get(dirJson.asString(), new String[0]);
        if (workingDir != null && !Files.isDirectory(workingDir, new LinkOption[0])) {
            throw Log.REST.notADirectory(dirJson.asString());
        }
        Json requestsJson = json.at(RESOURCES_KEY);
        creationConsumer.accept((Object)name, (Object)workingDir, (Object)requestsJson);
        return invocationHelper.newResponse(request, HttpResponseStatus.ACCEPTED).toFuture();
    }

    private static CompletionStage<RestResponse> handleDeleteBackup(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager) {
        return backupManager.removeBackup(name).handle((s, t) -> BackupManagerResource.handleDelete(invocationHelper, request, s, t));
    }

    private static CompletionStage<RestResponse> handleGetBackup(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager, Method method) {
        BackupManager.Status status = backupManager.getBackupStatus(name);
        switch (status) {
            case FAILED: {
                throw Log.REST.backupFailed();
            }
            case NOT_FOUND: {
                return invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
            }
            case IN_PROGRESS: {
                return invocationHelper.newResponse(request, HttpResponseStatus.ACCEPTED).toFuture();
            }
        }
        File zip = backupManager.getBackupLocation(name).toFile();
        NettyRestResponse.Builder responseBuilder = invocationHelper.newResponse(request).contentType(MediaType.APPLICATION_ZIP).header("Content-Disposition", String.format("attachment; filename=%s", zip.getName()));
        if (method == Method.GET) {
            responseBuilder.entity(zip).contentLength(zip.length());
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    static CompletionStage<RestResponse> handleRestoreRequest(InvocationHelper invocationHelper, RestRequest request, BackupManager backupManager, TriFunction<String, Path, Json, CompletionStage<Void>> function) {
        String name = request.variables().get("restoreName");
        Method method = request.method();
        switch (method) {
            case DELETE: {
                return BackupManagerResource.handleDeleteRestore(invocationHelper, name, request, backupManager);
            }
            case HEAD: {
                return BackupManagerResource.handleRestoreStatus(invocationHelper, name, request, backupManager);
            }
            case POST: {
                return BackupManagerResource.handleRestore(invocationHelper, name, request, backupManager, function);
            }
        }
        throw Log.REST.wrongMethod(method.toString());
    }

    static CompletionStage<RestResponse> handleDeleteRestore(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager) {
        return backupManager.removeRestore(name).handle((s, t) -> BackupManagerResource.handleDelete(invocationHelper, request, s, t));
    }

    static CompletionStage<RestResponse> handleRestoreStatus(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager) {
        BackupManager.Status status = backupManager.getRestoreStatus(name);
        switch (status) {
            case NOT_FOUND: {
                return invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND).toFuture();
            }
            case IN_PROGRESS: {
                return invocationHelper.newResponse(request, HttpResponseStatus.ACCEPTED).toFuture();
            }
            case COMPLETE: {
                return invocationHelper.newResponse(request, HttpResponseStatus.CREATED).toFuture();
            }
        }
        throw Log.REST.restoreFailed();
    }

    static CompletionStage<RestResponse> handleRestore(InvocationHelper invocationHelper, String name, RestRequest request, BackupManager backupManager, TriFunction<String, Path, Json, CompletionStage<Void>> function) {
        BackupManager.Status existingStatus = backupManager.getRestoreStatus(name);
        if (existingStatus != BackupManager.Status.NOT_FOUND) {
            return invocationHelper.newResponse(request, HttpResponseStatus.CONFLICT).toFuture();
        }
        Json resourcesJson = Json.object();
        MediaType contentType = request.contentType();
        boolean uploadedBackup = contentType.match(MediaType.MULTIPART_FORM_DATA);
        try {
            Path path;
            HttpPostMultipartRequestDecoder decoder;
            if (uploadedBackup) {
                FullHttpRequest nettyRequest = ((NettyRestRequest)request).getFullHttpRequest();
                DefaultHttpDataFactory factory = new DefaultHttpDataFactory(true);
                decoder = new HttpPostMultipartRequestDecoder((HttpDataFactory)factory, (HttpRequest)nettyRequest);
                DiskFileUpload backup = (DiskFileUpload)decoder.getBodyHttpData("backup");
                path = backup.getFile().toPath();
                DiskAttribute resources = (DiskAttribute)decoder.getBodyHttpData(RESOURCES_KEY);
                if (resources != null) {
                    resourcesJson = Json.read((String)resources.getString());
                }
            } else if (contentType.match(MediaType.APPLICATION_JSON)) {
                Json backupPath;
                decoder = null;
                Json json = Json.read((String)request.contents().asString());
                Json resources = json.at(RESOURCES_KEY);
                if (resources != null) {
                    resourcesJson = resources;
                }
                if ((backupPath = json.at(LOCATION_KEY)) == null) {
                    throw Log.REST.missingArgument("backup-location");
                }
                path = Paths.get(backupPath.asString(), new String[0]);
            } else {
                return invocationHelper.newResponse(request, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE).toFuture();
            }
            ((CompletionStage)function.apply((Object)name, (Object)path, (Object)resourcesJson)).whenComplete((Void2, t) -> {
                if (t != null) {
                    LOG.error(t);
                }
                if (uploadedBackup) {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        LOG.warnf(e, "Unable to delete uploaded backup file '%s'", path);
                    }
                    finally {
                        decoder.destroy();
                    }
                }
            });
            return invocationHelper.newResponse(request, HttpResponseStatus.ACCEPTED).toFuture();
        }
        catch (IOException e) {
            throw Util.unchecked((Throwable)e);
        }
    }

    static BackupManager.Resources getResources(Json json) {
        BackupManagerResources.Builder builder = new BackupManagerResources.Builder();
        if (json == null || json.isNull()) {
            return builder.includeAll().build();
        }
        Map jsonMap = json.asMap();
        if (jsonMap.isEmpty()) {
            return builder.includeAll().build();
        }
        for (Map.Entry e : jsonMap.entrySet()) {
            List resources = (List)e.getValue();
            BackupManager.Resources.Type type = BackupManager.Resources.Type.fromString((String)((String)e.getKey()));
            if (resources.size() == 1 && ((String)resources.get(0)).equals("*")) {
                builder.includeAll(new BackupManager.Resources.Type[]{type});
                continue;
            }
            builder.addResources(type, (Collection)resources);
        }
        return builder.build();
    }

    private static RestResponse handleDelete(InvocationHelper invocationHelper, RestRequest request, BackupManager.Status s, Throwable t) {
        if (t != null) {
            throw Util.unchecked((Throwable)t);
        }
        switch (s) {
            case NOT_FOUND: {
                return invocationHelper.newResponse(request, HttpResponseStatus.NOT_FOUND);
            }
            case IN_PROGRESS: {
                return invocationHelper.newResponse(request, HttpResponseStatus.ACCEPTED);
            }
            case COMPLETE: {
                return invocationHelper.newResponse(request, HttpResponseStatus.NO_CONTENT);
            }
        }
        throw Log.REST.backupDeleteFailed();
    }
}

