/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.security.auth.Subject;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.remoting.RemoteException;
import org.infinispan.rest.HttpMessageUtil;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseWriter;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.topology.MissingMembersException;
import org.infinispan.util.logging.LogFactory;

public class RestRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    protected static final Log logger = (Log)LogFactory.getLog(RestRequestHandler.class, Log.class);
    private final RestAccessLoggingHandler restAccessLoggingHandler = new RestAccessLoggingHandler();
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;
    private Subject subject;
    private String authorization;
    private final Authenticator authenticator;

    RestRequestHandler(RestServer restServer) {
        super(false);
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.authenticator = this.configuration.authentication().enabled() ? this.configuration.authentication().authenticator() : null;
    }

    void handleError(ChannelHandlerContext ctx, FullHttpRequest request, Throwable throwable) {
        Throwable cause = RestRequestHandler.filterCause(throwable);
        NettyRestResponse.Builder errorResponse = this.restServer.getInvocationHelper().newResponse(request);
        if (cause instanceof RestResponseException) {
            RestResponseException responseException = (RestResponseException)throwable;
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracef("Request failed: %s", responseException);
            }
            errorResponse.status(responseException.getStatus()).entity(responseException.getText());
        } else if (cause instanceof SecurityException) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracef("Request failed: %s", cause);
            }
            errorResponse.status(HttpResponseStatus.FORBIDDEN).entity(Util.unwrapExceptionMessage((Throwable)cause));
        } else if (cause instanceof NoSuchElementException) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracef("Request failed: %s", cause);
            }
            errorResponse.status(HttpResponseStatus.NOT_FOUND).entity(Util.unwrapExceptionMessage((Throwable)cause));
        } else if (cause instanceof CacheConfigurationException || cause instanceof IllegalArgumentException || cause instanceof EncodingException || cause instanceof Json.MalformedJsonException || cause instanceof MissingMembersException) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracef("Request failed: %s", cause);
            }
            errorResponse.status(HttpResponseStatus.BAD_REQUEST).entity(Util.unwrapExceptionMessage((Throwable)cause));
        } else {
            this.getLogger().errorWhileResponding(throwable);
            errorResponse.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(Util.unwrapExceptionMessage((Throwable)cause));
        }
        this.sendResponse(ctx, request, errorResponse.build());
    }

    public static Throwable filterCause(Throwable re) {
        if (re == null) {
            return null;
        }
        Class<?> tClass = re.getClass();
        Throwable cause = re.getCause();
        if (cause != null && (tClass == ExecutionException.class || tClass == CompletionException.class || tClass == InvocationTargetException.class || tClass == RemoteException.class || tClass == RuntimeException.class || tClass == CacheListenerException.class)) {
            return RestRequestHandler.filterCause(cause);
        }
        return re;
    }

    void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, NettyRestResponse response) {
        ctx.executor().execute(() -> ResponseWriter.forContent(response.getEntity()).writeResponse(ctx, request, response));
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        LookupResult invocationLookup;
        NettyRestRequest restRequest;
        if (logger.isTraceEnabled()) {
            logger.trace(HttpMessageUtil.dumpRequest((HttpRequest)request));
        }
        this.restAccessLoggingHandler.preLog(request);
        if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        if (!Method.contains(request.method().name())) {
            NettyRestResponse restResponse = this.restServer.getInvocationHelper().newResponse(request).status(HttpResponseStatus.FORBIDDEN).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        try {
            restRequest = new NettyRestRequest(request, (InetSocketAddress)ctx.channel().remoteAddress());
            invocationLookup = this.restServer.getRestDispatcher().lookupInvocation(restRequest);
            Invocation invocation = invocationLookup.getInvocation();
            if (invocation != null && invocation.deprecated()) {
                logger.warnDeprecatedCall(restRequest.toString());
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Error during REST dispatch", e);
            }
            NettyRestResponse restResponse = this.restServer.getInvocationHelper().newResponse(request).status(HttpResponseStatus.BAD_REQUEST).build();
            this.sendResponse(ctx, request, restResponse);
            return;
        }
        if (this.authenticator == null || this.isAnon(invocationLookup)) {
            this.handleRestRequest(ctx, restRequest, invocationLookup);
            return;
        }
        if (this.subject != null) {
            String authz = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
            if (Objects.equals(authz, this.authorization)) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Authorization header match, skipping authentication for %s", request);
                }
                restRequest.setSubject(this.subject);
                this.handleRestRequest(ctx, restRequest, invocationLookup);
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Authorization header mismatch:\n%s\n%s", authz, this.authorization);
            }
            this.subject = null;
            this.authorization = null;
        }
        this.authenticator.challenge(restRequest, ctx).whenComplete((authResponse, authThrowable) -> {
            boolean authorized;
            boolean hasError = authThrowable != null;
            boolean bl = authorized = !hasError && authResponse.getStatus() < HttpResponseStatus.BAD_REQUEST.code();
            if (authorized) {
                this.authorization = restRequest.getAuthorizationHeader();
                this.subject = restRequest.getSubject();
                this.handleRestRequest(ctx, restRequest, invocationLookup);
            } else {
                try {
                    if (hasError) {
                        this.handleError(ctx, request, (Throwable)authThrowable);
                    } else {
                        this.sendResponse(ctx, request, (NettyRestResponse)authResponse);
                    }
                }
                finally {
                    request.release();
                }
            }
        });
    }

    private boolean isAnon(LookupResult lookupResult) {
        if (lookupResult == null || lookupResult.getInvocation() == null) {
            return true;
        }
        return lookupResult.getInvocation().anonymous();
    }

    private void handleRestRequest(ChannelHandlerContext ctx, NettyRestRequest restRequest, LookupResult invocationLookup) {
        this.restServer.getRestDispatcher().dispatch(restRequest, invocationLookup).whenComplete((restResponse, throwable) -> {
            FullHttpRequest request = restRequest.getFullHttpRequest();
            try {
                if (throwable == null) {
                    NettyRestResponse nettyRestResponse = (NettyRestResponse)restResponse;
                    this.sendResponse(ctx, request, nettyRestResponse);
                } else {
                    this.handleError(ctx, request, (Throwable)throwable);
                }
            }
            finally {
                request.release();
            }
        });
    }

    protected Log getLogger() {
        return logger;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debugf(e, "Native IO Exception from %s", ctx.channel().remoteAddress());
            ctx.close();
        } else if (ctx.channel().isActive() || !(e instanceof IllegalStateException) || !e.getMessage().equals("ssl is null")) {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

