/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.DateUtils;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.RestResponseBuilder;
import org.infinispan.rest.stream.CacheChunkedStream;

public class NettyRestResponse
implements RestResponse {
    private final HttpResponse response;
    private final Object entity;

    private NettyRestResponse(HttpResponse response, Object entity) {
        this.response = response;
        this.entity = entity;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public int getStatus() {
        return this.response.status().code();
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    public static class Builder
    implements RestResponseBuilder<Builder> {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Object entity;
        private HttpResponseStatus httpStatus = HttpResponseStatus.OK;

        public Builder(RestRequest request, boolean ssl) {
            this(request.header(RequestHeader.USER_AGENT.getValue()), ssl);
        }

        public Builder(FullHttpRequest request, boolean ssl) {
            this(request.headers().get(RequestHeader.USER_AGENT.getValue()), ssl);
        }

        private Builder(String ua, boolean ssl) {
            if (ua != null && ua.startsWith("Mozilla")) {
                this.header("X-Frame-Options", "sameorigin").header("X-XSS-Protection", "1; mode=block");
                this.header("X-Content-Type-Options", "nosniff");
                this.header("Content-Security-Policy", "script-src 'self'");
            }
            if (ssl) {
                this.header("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
            }
        }

        @Override
        public NettyRestResponse build() {
            Object response = this.entity instanceof File || this.entity instanceof ChunkedInput || this.entity instanceof EventStream || this.entity instanceof CacheChunkedStream ? new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.buffer());
            response.setStatus(this.httpStatus);
            this.headers.forEach((arg_0, arg_1) -> Builder.lambda$build$0((HttpResponse)response, arg_0, arg_1));
            return new NettyRestResponse((HttpResponse)response, this.entity);
        }

        @Override
        public Builder header(String name, Object value) {
            this.setHeader(name, value);
            return this;
        }

        public Builder status(HttpResponseStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        @Override
        public Builder status(int status) {
            this.httpStatus = HttpResponseStatus.valueOf((int)status);
            return this;
        }

        @Override
        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder eTag(String tag) {
            this.setHeader(ResponseHeader.ETAG_HEADER.getValue(), tag);
            return this;
        }

        @Override
        public int getStatus() {
            return this.httpStatus.code();
        }

        @Override
        public Object getEntity() {
            return this.entity;
        }

        @Override
        public Builder contentType(MediaType mediaType) {
            if (mediaType != null) {
                this.contentType(mediaType.toString());
            }
            return this;
        }

        @Override
        public Builder contentType(String mediaType) {
            this.setHeader(ResponseHeader.CONTENT_TYPE_HEADER.getValue(), mediaType);
            return this;
        }

        @Override
        public Builder contentLength(long length) {
            this.setLongHeader(ResponseHeader.CONTENT_LENGTH_HEADER.getValue(), length);
            return this;
        }

        @Override
        public Builder expires(Date expires) {
            if (expires != null) {
                this.setDateHeader(ResponseHeader.EXPIRES_HEADER.getValue(), expires.getTime());
            }
            return this;
        }

        public Builder authenticate(String authentication) {
            if (authentication != null) {
                this.setHeader(ResponseHeader.WWW_AUTHENTICATE_HEADER.getValue(), authentication);
            }
            return this;
        }

        @Override
        public Builder lastModified(Long epoch) {
            this.setDateHeader(ResponseHeader.LAST_MODIFIED_HEADER.getValue(), epoch);
            return this;
        }

        @Override
        public Builder location(String location) {
            this.setHeader(ResponseHeader.LOCATION.getValue(), location);
            return this;
        }

        @Override
        public Builder addProcessedDate(Date d) {
            if (d != null) {
                this.setDateHeader(ResponseHeader.DATE_HEADER.getValue(), d.getTime());
            }
            return this;
        }

        @Override
        public Builder cacheControl(CacheControl cacheControl) {
            if (cacheControl != null) {
                this.setHeader(ResponseHeader.CACHE_CONTROL_HEADER.getValue(), cacheControl.toString());
            }
            return this;
        }

        @Override
        public Object getHeader(String header) {
            return this.headers.get(header);
        }

        public Builder timeToLive(long timeToLive) {
            if (timeToLive > -1L) {
                this.setLongHeader(ResponseHeader.TIME_TO_LIVE_HEADER.getValue(), TimeUnit.MILLISECONDS.toSeconds(timeToLive));
            }
            return this;
        }

        public Builder maxIdle(long maxIdle) {
            if (maxIdle > -1L) {
                this.setLongHeader(ResponseHeader.MAX_IDLE_TIME_HEADER.getValue(), TimeUnit.MILLISECONDS.toSeconds(maxIdle));
            }
            return this;
        }

        public Builder created(long created) {
            if (created > -1L) {
                this.setHeader(ResponseHeader.CREATED_HEADER.getValue(), String.valueOf(created));
            }
            return this;
        }

        public Builder lastUsed(long lastUsed) {
            if (lastUsed > -1L) {
                this.setHeader(ResponseHeader.LAST_USED_HEADER.getValue(), String.valueOf(lastUsed));
            }
            return this;
        }

        public Builder clusterPrimaryOwner(String primaryOwner) {
            this.setHeader(ResponseHeader.CLUSTER_PRIMARY_OWNER_HEADER.getValue(), primaryOwner);
            return this;
        }

        public Builder clusterBackupOwners(String primaryOwner) {
            this.setHeader(ResponseHeader.CLUSTER_BACKUP_OWNERS_HEADER.getValue(), primaryOwner);
            return this;
        }

        public Builder clusterNodeName(String nodeName) {
            this.setHeader(ResponseHeader.CLUSTER_NODE_NAME_HEADER.getValue(), nodeName);
            return this;
        }

        public Builder clusterServerAddress(String serverAddress) {
            this.setHeader(ResponseHeader.CLUSTER_SERVER_ADDRESS_HEADER.getValue(), serverAddress);
            return this;
        }

        public HttpResponseStatus getHttpStatus() {
            return this.httpStatus;
        }

        private void setHeader(String name, Object value) {
            if (value != null) {
                this.headers.computeIfAbsent(name, a -> new ArrayList()).add(value.toString());
            }
        }

        private void setLongHeader(String name, long value) {
            this.headers.computeIfAbsent(name, a -> new ArrayList()).add(String.valueOf(value));
        }

        private void setDateHeader(String name, Long epoch) {
            if (epoch != null) {
                String value = DateUtils.toRFC1123(epoch);
                this.setHeader(name, value);
            }
        }

        private static /* synthetic */ void lambda$build$0(HttpResponse response, String name, List values) {
            response.headers().set(name, (Iterable)values);
        }
    }
}

